# @turf/hex-grid

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## hexGrid

Takes a bounding box and the diameter of the cell and returns a [FeatureCollection][1] of flat-topped
hexagons or triangles ([Polygon][2] features) aligned in an "odd-q" vertical grid as
described in [Hexagonal Grids][3].

### Parameters

*   `bbox` **[BBox][4]** extent in \[minX, minY, maxX, maxY] order
*   `cellSide` **[number][5]** length of the side of the the hexagons or triangles, in units. It will also coincide with the
    radius of the circumcircle of the hexagons.
*   `options` **[Object][6]** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** used in calculating cell size. Supports all valid Turf [Units][7]. (optional, default `'kilometers'`)
    *   `options.properties` **[Object][6]** passed to each hexagon or triangle of the grid (optional, default `{}`)
    *   `options.mask` **[Feature][8]<([Polygon][2] | [MultiPolygon][9])>?** if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
    *   `options.triangles` **[boolean][10]** whether to return as triangles instead of hexagons (optional, default `false`)

### Examples

```javascript
var bbox = [-96,31,-84,40];
var cellSide = 50;
var options = {units: 'miles'};

var hexgrid = turf.hexGrid(bbox, cellSide, options);

//addToMap
var addToMap = [hexgrid];
```

Returns **[FeatureCollection][1]<[Polygon][2]>** a hexagonal grid

[1]: https://tools.ietf.org/html/rfc7946#section-3.3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[3]: http://www.redblobgames.com/grids/hexagons/

[4]: https://tools.ietf.org/html/rfc7946#section-5

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: https://turfjs.org/docs/api/types/Units

[8]: https://tools.ietf.org/html/rfc7946#section-3.2

[9]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/hex-grid
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
