// index.ts
import { polygon, featureCollection, isObject } from "@turf/helpers";
import { collectionOf } from "@turf/invariant";
import { cloneProperties } from "@turf/clone";
import * as d3voronoi from "d3-voronoi";
function coordsToPolygon(coords) {
  coords = coords.slice();
  coords.push(coords[0]);
  return polygon([coords]);
}
function voronoi2(points, options) {
  options = options || {};
  if (!isObject(options)) throw new Error("options is invalid");
  const bbox = options.bbox || [-180, -85, 180, 85];
  if (!points) throw new Error("points is required");
  if (!Array.isArray(bbox)) throw new Error("bbox is invalid");
  collectionOf(points, "Point", "points");
  return featureCollection(
    d3voronoi.voronoi().x((feature) => feature.geometry.coordinates[0]).y((feature) => feature.geometry.coordinates[1]).extent([
      [bbox[0], bbox[1]],
      [bbox[2], bbox[3]]
    ]).polygons(points.features).map(function(coords, index) {
      return Object.assign(coordsToPolygon(coords), {
        properties: cloneProperties(points.features[index].properties)
      });
    })
  );
}
var index_default = voronoi2;
export {
  index_default as default,
  voronoi2 as voronoi
};
//# sourceMappingURL=index.js.map