"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { newObj[key] = obj[key]; } } } newObj.default = obj; return newObj; } }// index.ts
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
var _clone = require('@turf/clone');
var _d3voronoi = require('d3-voronoi'); var d3voronoi = _interopRequireWildcard(_d3voronoi);
function coordsToPolygon(coords) {
  coords = coords.slice();
  coords.push(coords[0]);
  return _helpers.polygon.call(void 0, [coords]);
}
function voronoi2(points, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const bbox = options.bbox || [-180, -85, 180, 85];
  if (!points) throw new Error("points is required");
  if (!Array.isArray(bbox)) throw new Error("bbox is invalid");
  _invariant.collectionOf.call(void 0, points, "Point", "points");
  return _helpers.featureCollection.call(void 0, 
    d3voronoi.voronoi().x((feature) => feature.geometry.coordinates[0]).y((feature) => feature.geometry.coordinates[1]).extent([
      [bbox[0], bbox[1]],
      [bbox[2], bbox[3]]
    ]).polygons(points.features).map(function(coords, index) {
      return Object.assign(coordsToPolygon(coords), {
        properties: _clone.cloneProperties.call(void 0, points.features[index].properties)
      });
    })
  );
}
var index_default = voronoi2;



exports.default = index_default; exports.voronoi = voronoi2;
//# sourceMappingURL=index.cjs.map