"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _distance = require('@turf/distance');
var _intersect = require('@turf/intersect');
var _helpers = require('@turf/helpers');
function triangleGrid(bbox, cellSide, options = {}) {
  var results = [];
  var xFraction = cellSide / _distance.distance.call(void 0, [bbox[0], bbox[1]], [bbox[2], bbox[1]], options);
  var cellWidth = xFraction * (bbox[2] - bbox[0]);
  var yFraction = cellSide / _distance.distance.call(void 0, [bbox[0], bbox[1]], [bbox[0], bbox[3]], options);
  var cellHeight = yFraction * (bbox[3] - bbox[1]);
  var xi = 0;
  var currentX = bbox[0];
  while (currentX <= bbox[2]) {
    var yi = 0;
    var currentY = bbox[1];
    while (currentY <= bbox[3]) {
      var cellTriangle1 = null;
      var cellTriangle2 = null;
      if (xi % 2 === 0 && yi % 2 === 0) {
        cellTriangle1 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
        cellTriangle2 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY + cellHeight]
            ]
          ],
          options.properties
        );
      } else if (xi % 2 === 0 && yi % 2 === 1) {
        cellTriangle1 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
        cellTriangle2 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
      } else if (yi % 2 === 0 && xi % 2 === 1) {
        cellTriangle1 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
        cellTriangle2 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
      } else if (yi % 2 === 1 && xi % 2 === 1) {
        cellTriangle1 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY],
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY]
            ]
          ],
          options.properties
        );
        cellTriangle2 = _helpers.polygon.call(void 0, 
          [
            [
              [currentX, currentY + cellHeight],
              [currentX + cellWidth, currentY + cellHeight],
              [currentX + cellWidth, currentY],
              [currentX, currentY + cellHeight]
            ]
          ],
          options.properties
        );
      }
      if (options.mask) {
        if (_intersect.intersect.call(void 0, _helpers.featureCollection.call(void 0, [options.mask, cellTriangle1])))
          results.push(cellTriangle1);
        if (_intersect.intersect.call(void 0, _helpers.featureCollection.call(void 0, [options.mask, cellTriangle2])))
          results.push(cellTriangle2);
      } else {
        results.push(cellTriangle1);
        results.push(cellTriangle2);
      }
      currentY += cellHeight;
      yi++;
    }
    xi++;
    currentX += cellWidth;
  }
  return _helpers.featureCollection.call(void 0, results);
}
var index_default = triangleGrid;



exports.default = index_default; exports.triangleGrid = triangleGrid;
//# sourceMappingURL=index.cjs.map