// index.ts
import { coordEach } from "@turf/meta";
import { isObject } from "@turf/helpers";
import { getCoords } from "@turf/invariant";
import { clone } from "@turf/clone";
import { rhumbDestination } from "@turf/rhumb-destination";
function transformTranslate(geojson, distance, direction, options) {
  options = options || {};
  if (!isObject(options)) throw new Error("options is invalid");
  var units = options.units;
  var zTranslation = options.zTranslation;
  var mutate = options.mutate;
  if (!geojson) throw new Error("geojson is required");
  if (distance === void 0 || distance === null || isNaN(distance))
    throw new Error("distance is required");
  if (zTranslation && typeof zTranslation !== "number" && isNaN(zTranslation))
    throw new Error("zTranslation is not a number");
  zTranslation = zTranslation !== void 0 ? zTranslation : 0;
  if (distance === 0 && zTranslation === 0) return geojson;
  if (direction === void 0 || direction === null || isNaN(direction))
    throw new Error("direction is required");
  if (distance < 0) {
    distance = -distance;
    direction = direction + 180;
  }
  if (mutate === false || mutate === void 0) geojson = clone(geojson);
  coordEach(geojson, function(pointCoords) {
    var newCoords = getCoords(
      rhumbDestination(pointCoords, distance, direction, { units })
    );
    pointCoords[0] = newCoords[0];
    pointCoords[1] = newCoords[1];
    if (zTranslation && pointCoords.length === 3)
      pointCoords[2] += zTranslation;
  });
  return geojson;
}
var index_default = transformTranslate;
export {
  index_default as default,
  transformTranslate
};
//# sourceMappingURL=index.js.map