"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _meta = require('@turf/meta');
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
var _clone = require('@turf/clone');
var _rhumbdestination = require('@turf/rhumb-destination');
function transformTranslate(geojson, distance, direction, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  var units = options.units;
  var zTranslation = options.zTranslation;
  var mutate = options.mutate;
  if (!geojson) throw new Error("geojson is required");
  if (distance === void 0 || distance === null || isNaN(distance))
    throw new Error("distance is required");
  if (zTranslation && typeof zTranslation !== "number" && isNaN(zTranslation))
    throw new Error("zTranslation is not a number");
  zTranslation = zTranslation !== void 0 ? zTranslation : 0;
  if (distance === 0 && zTranslation === 0) return geojson;
  if (direction === void 0 || direction === null || isNaN(direction))
    throw new Error("direction is required");
  if (distance < 0) {
    distance = -distance;
    direction = direction + 180;
  }
  if (mutate === false || mutate === void 0) geojson = _clone.clone.call(void 0, geojson);
  _meta.coordEach.call(void 0, geojson, function(pointCoords) {
    var newCoords = _invariant.getCoords.call(void 0, 
      _rhumbdestination.rhumbDestination.call(void 0, pointCoords, distance, direction, { units })
    );
    pointCoords[0] = newCoords[0];
    pointCoords[1] = newCoords[1];
    if (zTranslation && pointCoords.length === 3)
      pointCoords[2] += zTranslation;
  });
  return geojson;
}
var index_default = transformTranslate;



exports.default = index_default; exports.transformTranslate = transformTranslate;
//# sourceMappingURL=index.cjs.map