# @turf/transform-translate

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## transformTranslate

Moves any geojson Feature or Geometry of a specified distance along a Rhumb Line
on the provided direction angle.

Note that this moves the points of your shape individually and can therefore change
the overall shape. How noticable this is depends on the distance and the used projection.

### Parameters

*   `geojson` **([GeoJSON][1] | [GeometryCollection][2])** object to be translated
*   `distance` **[number][3]** length of the motion; negative values determine motion in opposite direction
*   `direction` **[number][3]** of the motion; angle from North in decimal degrees, positive clockwise
*   `options` **[Object][4]** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** in which `distance` will be expressed; Supports all valid Turf [Units][5] (optional, default `'kilometers'`)
    *   `options.zTranslation` **[number][3]** length of the vertical motion, same unit of distance (optional, default `0`)
    *   `options.mutate` **[boolean][6]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
var poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
var translatedPoly = turf.transformTranslate(poly, 100, 35);

//addToMap
var addToMap = [poly, translatedPoly];
translatedPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **([GeoJSON][1] | [GeometryCollection][2])** the translated GeoJSON object

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.8

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://turfjs.org/docs/api/types/Units

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/transform-translate
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
