"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _centroid = require('@turf/centroid');
var _rhumbbearing = require('@turf/rhumb-bearing');
var _rhumbdistance = require('@turf/rhumb-distance');
var _rhumbdestination = require('@turf/rhumb-destination');
var _clone = require('@turf/clone');
var _meta = require('@turf/meta');
var _invariant = require('@turf/invariant');
var _helpers = require('@turf/helpers');
function transformRotate(geojson, angle, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const pivot = options.pivot;
  const mutate = options.mutate;
  if (!geojson) throw new Error("geojson is required");
  if (angle === void 0 || angle === null || isNaN(angle))
    throw new Error("angle is required");
  if (angle === 0) return geojson;
  const pivotCoord = pivot != null ? pivot : _centroid.centroid.call(void 0, geojson);
  if (mutate === false || mutate === void 0) geojson = _clone.clone.call(void 0, geojson);
  _meta.coordEach.call(void 0, geojson, function(pointCoords) {
    const initialAngle = _rhumbbearing.rhumbBearing.call(void 0, pivotCoord, pointCoords);
    const finalAngle = initialAngle + angle;
    const distance = _rhumbdistance.rhumbDistance.call(void 0, pivotCoord, pointCoords);
    const newCoords = _invariant.getCoords.call(void 0, 
      _rhumbdestination.rhumbDestination.call(void 0, pivotCoord, distance, finalAngle)
    );
    pointCoords[0] = newCoords[0];
    pointCoords[1] = newCoords[1];
  });
  return geojson;
}
var index_default = transformRotate;



exports.default = index_default; exports.transformRotate = transformRotate;
//# sourceMappingURL=index.cjs.map