// index.ts
import { booleanPointInPolygon } from "@turf/boolean-point-in-polygon";
import { clone } from "@turf/clone";
import { featureEach } from "@turf/meta";
function tag(points, polygons, field, outField) {
  points = clone(points);
  polygons = clone(polygons);
  featureEach(points, function(pt) {
    if (!pt.properties) pt.properties = {};
    featureEach(polygons, function(poly) {
      if (pt.properties && poly.properties) {
        if (pt.properties[outField] === void 0) {
          if (booleanPointInPolygon(pt, poly))
            pt.properties[outField] = poly.properties[field];
        }
      }
    });
  });
  return points;
}
var index_default = tag;
export {
  index_default as default,
  tag
};
//# sourceMappingURL=index.js.map