# @turf/simplify

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## simplify

Simplifies the geometries in a GeoJSON object. Uses the 2d version of
[simplify-js][1].

### Parameters

*   `geojson` **[GeoJSON][2]** GeoJSON object to be simplified
*   `options` **[Object][3]** Optional parameters (optional, default `{}`)

    *   `options.tolerance` **[number][4]** Simplification tolerance (optional, default `1`)
    *   `options.highQuality` **[boolean][5]** Produce a higher-quality simplification using a slower algorithm (optional, default `false`)
    *   `options.mutate` **[boolean][5]** Allow GeoJSON input to be mutated (significant performance improvement if true) (optional, default `false`)

### Examples

```javascript
const geojson = turf.polygon([[
  [-70.603637, -33.399918],
  [-70.614624, -33.395332],
  [-70.639343, -33.392466],
  [-70.659942, -33.394759],
  [-70.683975, -33.404504],
  [-70.697021, -33.419406],
  [-70.701141, -33.434306],
  [-70.700454, -33.446339],
  [-70.694274, -33.458369],
  [-70.682601, -33.465816],
  [-70.668869, -33.472117],
  [-70.646209, -33.473835],
  [-70.624923, -33.472117],
  [-70.609817, -33.468107],
  [-70.595397, -33.458369],
  [-70.587158, -33.442901],
  [-70.587158, -33.426283],
  [-70.590591, -33.414248],
  [-70.594711, -33.406224],
  [-70.603637, -33.399918]
]]);
const result0_01 = turf.simplify(geojson, {tolerance: 0.01 });
const result0_005 = turf.simplify(geojson, {tolerance: 0.005 });

//addToMap
const addToMap = [geojson, result0_01, result0_005]
```

Returns **[GeoJSON][2]** Simplified GeoJSON

[1]: https://mourner.github.io/simplify-js/

[2]: https://tools.ietf.org/html/rfc7946#section-3

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/simplify
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
