"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _circle = require('@turf/circle');
var _linearc = require('@turf/line-arc');
var _meta = require('@turf/meta');
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
function sector(center, radius, bearing1, bearing2, options = {}) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const properties = options.properties;
  if (!center) throw new Error("center is required");
  if (bearing1 === void 0 || bearing1 === null)
    throw new Error("bearing1 is required");
  if (bearing2 === void 0 || bearing2 === null)
    throw new Error("bearing2 is required");
  if (!radius) throw new Error("radius is required");
  if (typeof options !== "object") throw new Error("options must be an object");
  if (convertAngleTo360(bearing1) === convertAngleTo360(bearing2)) {
    return _circle.circle.call(void 0, center, radius, options);
  }
  const coords = _invariant.getCoords.call(void 0, center);
  const arc = _linearc.lineArc.call(void 0, center, radius, bearing1, bearing2, options);
  const sliceCoords = [[coords]];
  _meta.coordEach.call(void 0, arc, function(currentCoords) {
    sliceCoords[0].push(currentCoords);
  });
  sliceCoords[0].push(coords);
  return _helpers.polygon.call(void 0, sliceCoords, properties);
}
function convertAngleTo360(alpha) {
  let beta = alpha % 360;
  if (beta < 0) {
    beta += 360;
  }
  return beta;
}
var index_default = sector;



exports.default = index_default; exports.sector = sector;
//# sourceMappingURL=index.cjs.map