"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _helpers = require('@turf/helpers');
function sample(fc, num) {
  if (!fc) throw new Error("fc is required");
  if (num === null || num === void 0) throw new Error("num is required");
  if (typeof num !== "number") throw new Error("num must be a number");
  var outFC = _helpers.featureCollection.call(void 0, getRandomSubarray(fc.features, num));
  return outFC;
}
function getRandomSubarray(arr, size) {
  var shuffled = arr.slice(0), i = arr.length, min = i - size, temp, index;
  while (i-- > min) {
    index = Math.floor((i + 1) * Math.random());
    temp = shuffled[index];
    shuffled[index] = shuffled[i];
    shuffled[i] = temp;
  }
  return shuffled.slice(min);
}
var index_default = sample;



exports.default = index_default; exports.sample = sample;
//# sourceMappingURL=index.cjs.map