# @turf/rhumb-distance

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rhumbDistance

Calculates the distance along a rhumb line between two [points][1] in [Units][2]

### Parameters

*   `from` **[Coord][3]** origin point
*   `to` **[Coord][3]** destination point
*   `options` **[Object][4]?** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** Supports all valid Turf [Units][2] (optional, default `'kilometers'`)

### Examples

```javascript
var from = turf.point([-75.343, 39.984]);
var to = turf.point([-75.534, 39.123]);
var options = {units: 'miles'};

var distance = turf.rhumbDistance(from, to, options);

//addToMap
var addToMap = [from, to];
from.properties.distance = distance;
to.properties.distance = distance;
```

Returns **[number][5]** distance between the two points

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://turfjs.org/docs/api/types/Units

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/rhumb-distance
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
