// index.ts
import { clone } from "@turf/clone";
import { booleanClockwise } from "@turf/boolean-clockwise";
import { geomEach, featureEach } from "@turf/meta";
import { getCoords } from "@turf/invariant";
import { featureCollection, isObject } from "@turf/helpers";
function rewind(geojson, options = {}) {
  var _a, _b;
  options = options || {};
  if (!isObject(options)) throw new Error("options is invalid");
  const mutate = (_a = options.mutate) != null ? _a : false;
  const reverse = (_b = options.reverse) != null ? _b : false;
  if (!geojson) throw new Error("<geojson> is required");
  if (typeof reverse !== "boolean")
    throw new Error("<reverse> must be a boolean");
  if (typeof mutate !== "boolean")
    throw new Error("<mutate> must be a boolean");
  if (!mutate && geojson.type !== "Point" && geojson.type !== "MultiPoint") {
    geojson = clone(geojson);
  }
  const results = [];
  switch (geojson.type) {
    case "GeometryCollection":
      geomEach(geojson, function(geometry) {
        rewindFeature(geometry, reverse);
      });
      return geojson;
    case "FeatureCollection":
      featureEach(geojson, function(feature) {
        const rewoundFeature = rewindFeature(feature, reverse);
        featureEach(rewoundFeature, function(result) {
          results.push(result);
        });
      });
      return featureCollection(results);
  }
  return rewindFeature(geojson, reverse);
}
function rewindFeature(geojson, reverse) {
  const type = geojson.type === "Feature" ? geojson.geometry.type : geojson.type;
  switch (type) {
    case "GeometryCollection":
      geomEach(geojson, function(geometry) {
        rewindFeature(geometry, reverse);
      });
      return geojson;
    case "LineString":
      rewindLineString(getCoords(geojson), reverse);
      return geojson;
    case "Polygon":
      rewindPolygon(getCoords(geojson), reverse);
      return geojson;
    case "MultiLineString":
      getCoords(geojson).forEach(function(lineCoords) {
        rewindLineString(lineCoords, reverse);
      });
      return geojson;
    case "MultiPolygon":
      getCoords(geojson).forEach(function(lineCoords) {
        rewindPolygon(lineCoords, reverse);
      });
      return geojson;
    case "Point":
    case "MultiPoint":
      return geojson;
  }
}
function rewindLineString(coords, reverse) {
  if (booleanClockwise(coords) === reverse) coords.reverse();
}
function rewindPolygon(coords, reverse) {
  if (booleanClockwise(coords[0]) !== reverse) {
    coords[0].reverse();
  }
  for (let i = 1; i < coords.length; i++) {
    if (booleanClockwise(coords[i]) === reverse) {
      coords[i].reverse();
    }
  }
}
var index_default = rewind;
export {
  index_default as default,
  rewind
};
//# sourceMappingURL=index.js.map