# @turf/rewind

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rewind

Rewind [(Multi)LineString][1] or [(Multi)Polygon][2] outer ring counterclockwise and inner rings clockwise (Uses [Shoelace Formula][3]).

### Parameters

*   `geojson` **[GeoJSON][4]** input GeoJSON Polygon
*   `options` **[Object][5]** Optional parameters (optional, default `{}`)

    *   `options.reverse` **[boolean][6]** enable reverse winding (optional, default `false`)
    *   `options.mutate` **[boolean][6]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
var polygon = turf.polygon([[[121, -29], [138, -29], [138, -18], [121, -18], [121, -29]]]);

var rewind = turf.rewind(polygon);

//addToMap
var addToMap = [rewind];
```

Returns **[GeoJSON][4]** rewind Polygon

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[3]: http://en.wikipedia.org/wiki/Shoelace_formula

[4]: https://tools.ietf.org/html/rfc7946#section-3

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/rewind
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
