// index.ts
import { booleanIntersects as intersect } from "@turf/boolean-intersects";
import {
  convertLength,
  featureCollection,
  polygon
} from "@turf/helpers";
function rectangleGrid(bbox, cellWidth, cellHeight, options = {}) {
  const results = [];
  const west = bbox[0];
  const south = bbox[1];
  const east = bbox[2];
  const north = bbox[3];
  const bboxWidth = east - west;
  const cellWidthDeg = convertLength(cellWidth, options.units, "degrees");
  const bboxHeight = north - south;
  const cellHeightDeg = convertLength(cellHeight, options.units, "degrees");
  const columns = Math.floor(Math.abs(bboxWidth) / cellWidthDeg);
  const rows = Math.floor(Math.abs(bboxHeight) / cellHeightDeg);
  const deltaX = (bboxWidth - columns * cellWidthDeg) / 2;
  const deltaY = (bboxHeight - rows * cellHeightDeg) / 2;
  let currentX = west + deltaX;
  for (let column = 0; column < columns; column++) {
    let currentY = south + deltaY;
    for (let row = 0; row < rows; row++) {
      const cellPoly = polygon(
        [
          [
            [currentX, currentY],
            [currentX, currentY + cellHeightDeg],
            [currentX + cellWidthDeg, currentY + cellHeightDeg],
            [currentX + cellWidthDeg, currentY],
            [currentX, currentY]
          ]
        ],
        options.properties
      );
      if (options.mask) {
        if (intersect(options.mask, cellPoly)) {
          results.push(cellPoly);
        }
      } else {
        results.push(cellPoly);
      }
      currentY += cellHeightDeg;
    }
    currentX += cellWidthDeg;
  }
  return featureCollection(results);
}
var index_default = rectangleGrid;
export {
  index_default as default,
  rectangleGrid
};
//# sourceMappingURL=index.js.map