# @turf/random

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## randomPosition

Returns a random position within a [bounding box][1].

### Parameters

*   `bbox` **[BBox][1]** a bounding box inside of which positions are placed. (optional, default `[-180,-90,180,90]`)

### Examples

```javascript
var position = turf.randomPosition([-180, -90, 180, 90])
// => position
```

*   Throws **[Error][2]** if bbox is invalid

Returns **[Position][3]** Position \[longitude, latitude]

## randomPoint

Returns a random [point][4].

### Parameters

*   `count` **[number][5]** how many geometries will be generated (optional, default `1`)
*   `options` **[Object][6]** Optional parameters (optional, default `{}`)

    *   `options.bbox` **[BBox][1]** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)

### Examples

```javascript
var points = turf.randomPoint(25, {bbox: [-180, -90, 180, 90]})
// => points
```

*   Throws **[Error][2]** if bbox is invalid

Returns **[FeatureCollection][7]<[Point][8]>** GeoJSON FeatureCollection of points

## randomPolygon

Returns a random [polygon][9].

### Parameters

*   `count` **[number][5]** how many geometries will be generated (optional, default `1`)
*   `options` **[Object][6]** Optional parameters (optional, default `{}`)

    *   `options.bbox` **[BBox][1]** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)
    *   `options.num_vertices` **[number][5]** is how many coordinates each LineString will contain. (optional, default `10`)
    *   `options.max_radial_length` **[number][5]** is the maximum number of decimal degrees latitude or longitude that a
        vertex can reach out of the center of the Polygon. (optional, default `10`)

### Examples

```javascript
var polygons = turf.randomPolygon(25, {bbox: [-180, -90, 180, 90]})
// => polygons
```

*   Throws **[Error][2]** if bbox is invalid

Returns **[FeatureCollection][7]<[Polygon][10]>** GeoJSON FeatureCollection of polygons

## randomLineString

Returns a random [LineString][11].

### Parameters

*   `count` **[number][5]** how many geometries will be generated (optional, default `1`)
*   `options` **[Object][6]** Optional parameters (optional, default `{}`)

    *   `options.bbox` **[BBox][1]** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)
    *   `options.num_vertices` **[number][5]** is how many coordinates each LineString will contain. (optional, default `10`)
    *   `options.max_length` **[number][5]** is the maximum number of decimal degrees that a
        vertex can be from its predecessor (optional, default `0.0001`)
    *   `options.max_rotation` **[number][5]** is the maximum number of radians that a
        line segment can turn from the previous segment. (optional, default `Math.PI/8`)

### Examples

```javascript
var lineStrings = turf.randomLineString(25, {bbox: [-180, -90, 180, 90]})
// => lineStrings
```

*   Throws **[Error][2]** if bbox is invalid

Returns **[FeatureCollection][7]<[LineString][11]>** GeoJSON FeatureCollection of linestrings

[1]: https://tools.ietf.org/html/rfc7946#section-5

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[3]: https://developer.mozilla.org/docs/Web/API/Position

[4]: point

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: https://tools.ietf.org/html/rfc7946#section-3.3

[8]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[9]: polygon

[10]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[11]: https://tools.ietf.org/html/rfc7946#section-3.1.4

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/random
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
