import { Polygon, MultiPolygon, Feature, FeatureCollection, Point } from 'geojson';
import { Coord } from '@turf/helpers';

/**
 * Finds the tangents of a {@link Polygon|(Multi)Polygon} from a {@link Point}.
 *
 * @function
 * @param {Coord} pt to calculate the tangent points from
 * @param {Feature<Polygon|MultiPolygon>} polygon to get tangents from
 * @returns {FeatureCollection<Point>} Feature Collection containing the two tangent points
 * @example
 * var polygon = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
 * var point = turf.point([61, 5]);
 *
 * var tangents = turf.polygonTangents(point, polygon)
 *
 * //addToMap
 * var addToMap = [tangents, point, polygon];
 */
declare function polygonTangents<T extends Polygon | MultiPolygon>(pt: Coord, polygon: Feature<T> | T): FeatureCollection<Point>;

export { polygonTangents as default, polygonTangents };
