"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _helpers = require('@turf/helpers');
var _meta = require('@turf/meta');
function polygonSmooth(inputPolys, options) {
  options = options || {};
  options.iterations = options.iterations || 1;
  const { iterations } = options;
  const outPolys = [];
  if (!inputPolys) throw new Error("inputPolys is required");
  _meta.geomEach.call(void 0, inputPolys, function(geom, geomIndex, properties) {
    if (geom.type === "Polygon") {
      let outCoords = [[]];
      for (let i = 0; i < iterations; i++) {
        let tempOutput = [];
        let poly = geom;
        if (i > 0) {
          poly = _helpers.polygon.call(void 0, outCoords).geometry;
        }
        processPolygon(poly, tempOutput);
        outCoords = tempOutput.slice(0);
      }
      outPolys.push(_helpers.polygon.call(void 0, outCoords, properties));
    } else if (geom.type === "MultiPolygon") {
      let outCoords = [[[]]];
      for (let y = 0; y < iterations; y++) {
        let tempOutput = [];
        let poly = geom;
        if (y > 0) {
          poly = _helpers.multiPolygon.call(void 0, outCoords).geometry;
        }
        processMultiPolygon(poly, tempOutput);
        outCoords = tempOutput.slice(0);
      }
      outPolys.push(_helpers.multiPolygon.call(void 0, outCoords, properties));
    } else {
      throw new Error("geometry is invalid, must be Polygon or MultiPolygon");
    }
  });
  return _helpers.featureCollection.call(void 0, outPolys);
}
function processPolygon(poly, tempOutput) {
  var previousCoord;
  var previousGeometryIndex;
  _meta.coordEach.call(void 0, 
    poly,
    function(currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
      if (previousGeometryIndex !== geometryIndex) {
        tempOutput.push([]);
      } else {
        var p0x = previousCoord[0];
        var p0y = previousCoord[1];
        var p1x = currentCoord[0];
        var p1y = currentCoord[1];
        tempOutput[geometryIndex].push([
          0.75 * p0x + 0.25 * p1x,
          0.75 * p0y + 0.25 * p1y
        ]);
        tempOutput[geometryIndex].push([
          0.25 * p0x + 0.75 * p1x,
          0.25 * p0y + 0.75 * p1y
        ]);
      }
      previousCoord = currentCoord;
      previousGeometryIndex = geometryIndex;
    },
    false
  );
  tempOutput.forEach(function(ring) {
    ring.push(ring[0]);
  });
}
function processMultiPolygon(poly, tempOutput) {
  let previousCoord;
  let previousMultiFeatureIndex;
  let previousGeometryIndex;
  _meta.coordEach.call(void 0, 
    poly,
    function(currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
      if (previousMultiFeatureIndex !== multiFeatureIndex) {
        tempOutput.push([[]]);
      } else if (previousGeometryIndex !== geometryIndex) {
        tempOutput[multiFeatureIndex].push([]);
      } else {
        var p0x = previousCoord[0];
        var p0y = previousCoord[1];
        var p1x = currentCoord[0];
        var p1y = currentCoord[1];
        tempOutput[multiFeatureIndex][geometryIndex].push([
          0.75 * p0x + 0.25 * p1x,
          0.75 * p0y + 0.25 * p1y
        ]);
        tempOutput[multiFeatureIndex][geometryIndex].push([
          0.25 * p0x + 0.75 * p1x,
          0.25 * p0y + 0.75 * p1y
        ]);
      }
      previousCoord = currentCoord;
      previousMultiFeatureIndex = multiFeatureIndex;
      previousGeometryIndex = geometryIndex;
    },
    false
  );
  tempOutput.forEach(function(poly2) {
    poly2.forEach(function(ring) {
      ring.push(ring[0]);
    });
  });
}
var index_default = polygonSmooth;



exports.default = index_default; exports.polygonSmooth = polygonSmooth;
//# sourceMappingURL=index.cjs.map