// index.ts
import { booleanPointInPolygon } from "@turf/boolean-point-in-polygon";
import { pointToLineDistance } from "@turf/point-to-line-distance";
import { polygonToLine } from "@turf/polygon-to-line";
import { getGeom } from "@turf/invariant";
import { flattenEach } from "@turf/meta";
import { polygon } from "@turf/helpers";
function pointToPolygonDistance(point, polygonOrMultiPolygon, options = {}) {
  var _a, _b;
  const method = (_a = options.method) != null ? _a : "geodesic";
  const units = (_b = options.units) != null ? _b : "kilometers";
  if (!point) throw new Error("point is required");
  if (!polygonOrMultiPolygon)
    throw new Error("polygon or multi-polygon is required");
  const geom = getGeom(polygonOrMultiPolygon);
  if (geom.type === "MultiPolygon") {
    const distances = geom.coordinates.map(
      (coords) => pointToPolygonDistance(point, polygon(coords), { method, units })
    );
    return Math.min(...distances.map(Math.abs)) * (booleanPointInPolygon(point, polygonOrMultiPolygon) ? -1 : 1);
  }
  if (geom.coordinates.length > 1) {
    const [exteriorDistance, ...interiorDistances] = geom.coordinates.map(
      (coords) => pointToPolygonDistance(point, polygon([coords]), { method, units })
    );
    if (exteriorDistance >= 0) return exteriorDistance;
    const smallestInteriorDistance = Math.min(...interiorDistances);
    if (smallestInteriorDistance < 0) return Math.abs(smallestInteriorDistance);
    return Math.max(smallestInteriorDistance * -1, exteriorDistance);
  }
  const lines = polygonToLine(geom);
  let minDistance = Infinity;
  flattenEach(lines, (feature) => {
    minDistance = Math.min(
      minDistance,
      pointToLineDistance(point, feature, {
        method,
        units
      })
    );
  });
  return booleanPointInPolygon(point, geom) ? -minDistance : minDistance;
}
var index_default = pointToPolygonDistance;
export {
  index_default as default,
  pointToPolygonDistance
};
//# sourceMappingURL=index.js.map