"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts





var _helpers = require('@turf/helpers');
var _nearestpointonline = require('@turf/nearest-point-on-line');
var _invariant = require('@turf/invariant');
var _meta = require('@turf/meta');
var _rhumbdistance = require('@turf/rhumb-distance');
function pointToLineDistance(pt, line, options = {}) {
  var _a, _b;
  const method = (_a = options.method) != null ? _a : "geodesic";
  const units = (_b = options.units) != null ? _b : "kilometers";
  if (!pt) {
    throw new Error("pt is required");
  }
  if (Array.isArray(pt)) {
    pt = _helpers.point.call(void 0, pt);
  } else if (pt.type === "Point") {
    pt = _helpers.feature.call(void 0, pt);
  } else {
    _invariant.featureOf.call(void 0, pt, "Point", "point");
  }
  if (!line) {
    throw new Error("line is required");
  }
  if (Array.isArray(line)) {
    line = _helpers.lineString.call(void 0, line);
  } else if (line.type === "LineString") {
    line = _helpers.feature.call(void 0, line);
  } else {
    _invariant.featureOf.call(void 0, line, "LineString", "line");
  }
  let distance = Infinity;
  const p = pt.geometry.coordinates;
  _meta.segmentEach.call(void 0, line, (segment) => {
    if (segment) {
      const a = segment.geometry.coordinates[0];
      const b = segment.geometry.coordinates[1];
      const d = distanceToSegment(p, a, b, { method });
      if (d < distance) {
        distance = d;
      }
    }
  });
  return _helpers.convertLength.call(void 0, distance, "degrees", units);
}
function distanceToSegment(p, a, b, options) {
  if (options.method === "geodesic") {
    const nearest = _nearestpointonline.nearestPointOnLine.call(void 0, _helpers.lineString.call(void 0, [a, b]).geometry, p, {
      units: "degrees"
    });
    return nearest.properties.dist;
  }
  const v = [b[0] - a[0], b[1] - a[1]];
  const w = [p[0] - a[0], p[1] - a[1]];
  const c1 = dot(w, v);
  if (c1 <= 0) {
    return _rhumbdistance.rhumbDistance.call(void 0, p, a, { units: "degrees" });
  }
  const c2 = dot(v, v);
  if (c2 <= c1) {
    return _rhumbdistance.rhumbDistance.call(void 0, p, b, { units: "degrees" });
  }
  const b2 = c1 / c2;
  const Pb = [a[0] + b2 * v[0], a[1] + b2 * v[1]];
  return _rhumbdistance.rhumbDistance.call(void 0, p, Pb, { units: "degrees" });
}
function dot(u, v) {
  return u[0] * v[0] + u[1] * v[1];
}
var index_default = pointToLineDistance;



exports.default = index_default; exports.pointToLineDistance = pointToLineDistance;
//# sourceMappingURL=index.cjs.map