# @turf/point-to-line-distance

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointToLineDistance

Calculates the distance between a given point and the nearest point on a
line. Sometimes referred to as the cross track distance.

### Parameters

*   `pt` **([Feature][1]<[Point][2]> | [Array][3]<[number][4]>)** Feature or Geometry
*   `line` **[Feature][1]<[LineString][5]>** GeoJSON Feature or Geometry
*   `options` **[Object][6]** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** Supports all valid Turf [Units][7] (optional, default `"kilometers"`)
    *   `options.method` **[string][8]** whether to calculate the distance based on geodesic (spheroid) or
        planar (flat) method. Valid options are 'geodesic' or 'planar'. (optional, default `"geodesic"`)

### Examples

```javascript
var pt = turf.point([0, 0]);
var line = turf.lineString([[1, 1],[-1, 1]]);

var distance = turf.pointToLineDistance(pt, line, {units: 'miles'});
//=69.11854715938406
```

Returns **[number][4]** distance between point and line

[1]: https://tools.ietf.org/html/rfc7946#section-3.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: https://turfjs.org/docs/api/types/Units

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/point-to-line-distance
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
