# @turf/point-on-feature

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointOnFeature

Takes a Feature or FeatureCollection and returns a [Point][1] guaranteed to be on the surface of the feature.

*   Given a [Polygon][2], the point will be in the area of the polygon
*   Given a [LineString][3], the point will be along the string
*   Given a [Point][1], the point will the same as the input

### Parameters

*   `geojson` **[GeoJSON][4]** any Feature or FeatureCollection

### Examples

```javascript
var polygon = turf.polygon([[
  [116, -36],
  [131, -32],
  [146, -43],
  [155, -25],
  [133, -9],
  [111, -22],
  [116, -36]
]]);

var pointOnPolygon = turf.pointOnFeature(polygon);

//addToMap
var addToMap = [polygon, pointOnPolygon];
```

Returns **[Feature][5]<[Point][1]>** a point on the surface of `input`

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[4]: https://tools.ietf.org/html/rfc7946#section-3

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/point-on-feature
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
