"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _booleanwithin = require('@turf/boolean-within');
var _distance = require('@turf/distance');
var _helpers = require('@turf/helpers');
function pointGrid(bbox, cellSide, options = {}) {
  if (options.mask && !options.units) options.units = "kilometers";
  var results = [];
  var west = bbox[0];
  var south = bbox[1];
  var east = bbox[2];
  var north = bbox[3];
  var xFraction = cellSide / _distance.distance.call(void 0, [west, south], [east, south], options);
  var cellWidth = xFraction * (east - west);
  var yFraction = cellSide / _distance.distance.call(void 0, [west, south], [west, north], options);
  var cellHeight = yFraction * (north - south);
  var bboxWidth = east - west;
  var bboxHeight = north - south;
  var columns = Math.floor(bboxWidth / cellWidth);
  var rows = Math.floor(bboxHeight / cellHeight);
  var deltaX = (bboxWidth - columns * cellWidth) / 2;
  var deltaY = (bboxHeight - rows * cellHeight) / 2;
  var currentX = west + deltaX;
  while (currentX <= east) {
    var currentY = south + deltaY;
    while (currentY <= north) {
      var cellPt = _helpers.point.call(void 0, [currentX, currentY], options.properties);
      if (options.mask) {
        if (_booleanwithin.booleanWithin.call(void 0, cellPt, options.mask)) results.push(cellPt);
      } else {
        results.push(cellPt);
      }
      currentY += cellHeight;
    }
    currentX += cellWidth;
  }
  return _helpers.featureCollection.call(void 0, results);
}
var index_default = pointGrid;



exports.default = index_default; exports.pointGrid = pointGrid;
//# sourceMappingURL=index.cjs.map