# @turf/nearest-point-to-line

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## nearestPointToLine

Returns the closest [point][1], of a [collection][2] of points,
to a [line][3]. The returned point has a `dist` property indicating its distance to the line.

### Parameters

*   `points` **([FeatureCollection][2] | [GeometryCollection][4]<[Point][1]>)** Point Collection
*   `line` **([Feature][5] | [Geometry][6]<[LineString][3]>)** Line Feature
*   `options` **[Object][7]?** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** unit of the output distance property. Supports all valid Turf [Units][8].
        (eg: degrees, radians, miles, or kilometers) (optional, default `'kilometers'`)
    *   `options.properties` **[Object][7]** Translate Properties to Point (optional, default `{}`)

### Examples

```javascript
var pt1 = turf.point([0, 0]);
var pt2 = turf.point([0.5, 0.5]);
var points = turf.featureCollection([pt1, pt2]);
var line = turf.lineString([[1,1], [-1,1]]);

var nearest = turf.nearestPointToLine(points, line);

//addToMap
var addToMap = [nearest, line];
```

Returns **[Feature][5]<[Point][1]>** the closest point

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.3

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.8

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://turfjs.org/docs/api/types/Units

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/nearest-point-to-line
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
