// index.ts
import { distanceWeight as spatialWeight } from "@turf/distance-weight";
import { featureEach } from "@turf/meta";
function moranIndex(fc, options) {
  var _a, _b;
  const inputField = options.inputField;
  const threshold = options.threshold || 1e5;
  const p = options.p || 2;
  const binary = (_a = options.binary) != null ? _a : false;
  const alpha = options.alpha || -1;
  const standardization = (_b = options.standardization) != null ? _b : true;
  const weight = spatialWeight(fc, {
    alpha,
    binary,
    p,
    standardization,
    threshold
  });
  const y = [];
  featureEach(fc, (feature) => {
    const feaProperties = feature.properties || {};
    y.push(feaProperties[inputField]);
  });
  const yMean = mean(y);
  const yVar = variance(y);
  let weightSum = 0;
  let s0 = 0;
  let s1 = 0;
  let s2 = 0;
  const n = weight.length;
  for (let i = 0; i < n; i++) {
    let subS2 = 0;
    for (let j = 0; j < n; j++) {
      weightSum += weight[i][j] * (y[i] - yMean) * (y[j] - yMean);
      s0 += weight[i][j];
      s1 += Math.pow(weight[i][j] + weight[j][i], 2);
      subS2 += weight[i][j] + weight[j][i];
    }
    s2 += Math.pow(subS2, 2);
  }
  s1 = 0.5 * s1;
  const moranIndex2 = weightSum / s0 / yVar;
  const expectedMoranIndex = -1 / (n - 1);
  const vNum = n * n * s1 - n * s2 + 3 * (s0 * s0);
  const vDen = (n - 1) * (n + 1) * (s0 * s0);
  const vNorm = vNum / vDen - expectedMoranIndex * expectedMoranIndex;
  const stdNorm = Math.sqrt(vNorm);
  const zNorm = (moranIndex2 - expectedMoranIndex) / stdNorm;
  return {
    expectedMoranIndex,
    moranIndex: moranIndex2,
    stdNorm,
    zNorm
  };
}
function mean(y) {
  let sum = 0;
  for (const item of y) {
    sum += item;
  }
  return sum / y.length;
}
function variance(y) {
  const yMean = mean(y);
  let sum = 0;
  for (const item of y) {
    sum += Math.pow(item - yMean, 2);
  }
  return sum / y.length;
}
var index_default = moranIndex;
export {
  index_default as default,
  moranIndex
};
//# sourceMappingURL=index.js.map