# @turf/moran-index

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## MoranIndex

Type: [object][1]

### Properties

*   `moranIndex` **[number][2]** the moran's Index of the observed feature set
*   `expectedMoranIndex` **[number][2]** the moran's Index of the random distribution
*   `stdNorm` **[number][2]** the standard devitaion of the random distribution
*   `zNorm` **[number][2]** the z-score of the observe samples with regard to the random distribution

## moranIndex

Moran's I measures patterns of attribute values associated with features.
The method reveal whether similar values tend to occur near each other,
or whether high or low values are interspersed.

Moran's I > 0 means a clusterd pattern.
Moran's I < 0 means a dispersed pattern.
Moran's I = 0 means a random pattern.

In order to test the significance of the result. The z score is calculated.
A positive enough z-score (ex. >1.96) indicates clustering,
while a negative enough z-score (ex. <-1.96) indicates a dispersed pattern.

the z-score can be calculated based on a normal or random assumption.

**Bibliography**\*

1.  [Moran's I][3]

2.  [pysal][4]

3.  Andy Mitchell, The ESRI Guide to GIS Analysis Volume 2: Spatial Measurements & Statistics.

### Parameters

*   `fc` **[FeatureCollection][5]\<any>**&#x20;
*   `options` **[Object][1]**&#x20;

    *   `options.inputField` **[string][6]** the property name, must contain numeric values
    *   `options.threshold` **[number][2]** the distance threshold (optional, default `100000`)
    *   `options.p` **[number][2]** the Minkowski p-norm distance parameter (optional, default `2`)
    *   `options.binary` **[boolean][7]** whether transfrom the distance to binary (optional, default `false`)
    *   `options.alpha` **[number][2]** the distance decay parameter (optional, default `-1`)
    *   `options.standardization` **[boolean][7]** wheter row standardization the distance (optional, default `true`)

### Examples

```javascript
const bbox = [-65, 40, -63, 42];
const dataset = turf.randomPoint(100, { bbox: bbox });

const result = turf.moranIndex(dataset, {
  inputField: 'CRIME',
});
```

Returns **[MoranIndex][8]**&#x20;

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://en.wikipedia.org/wiki/Moran%27s_I

[4]: http://pysal.readthedocs.io/en/latest/index.html

[5]: https://tools.ietf.org/html/rfc7946#section-3.3

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[8]: #moranindex

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/moran-index
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
