"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { newObj[key] = obj[key]; } } } newObj.default = obj; return newObj; } }// index.ts
var _helpers = require('@turf/helpers');
var _polyclipts = require('polyclip-ts'); var polyclip = _interopRequireWildcard(_polyclipts);
var _clone = require('@turf/clone');
function mask(polygon, mask2, options) {
  var _a;
  const mutate = (_a = options == null ? void 0 : options.mutate) != null ? _a : false;
  let maskTemplate = mask2;
  if (mask2 && mutate === false) {
    maskTemplate = _clone.clone.call(void 0, mask2);
  }
  const maskPolygon = createMask(maskTemplate);
  let polygonOuters = null;
  if (polygon.type === "FeatureCollection") {
    polygonOuters = unionFc(polygon);
  } else if (polygon.type === "Feature") {
    polygonOuters = createGeomFromPolygonClippingOutput(
      polyclip.union(polygon.geometry.coordinates)
    );
  } else {
    polygonOuters = createGeomFromPolygonClippingOutput(
      polyclip.union(polygon.coordinates)
    );
  }
  polygonOuters.geometry.coordinates.forEach(function(contour) {
    maskPolygon.geometry.coordinates.push(contour[0]);
  });
  return maskPolygon;
}
function unionFc(fc) {
  const unioned = fc.features.length === 2 ? polyclip.union(
    fc.features[0].geometry.coordinates,
    fc.features[1].geometry.coordinates
  ) : polyclip.union.apply(
    polyclip,
    fc.features.map(function(f) {
      return f.geometry.coordinates;
    })
  );
  return createGeomFromPolygonClippingOutput(unioned);
}
function createGeomFromPolygonClippingOutput(unioned) {
  return _helpers.multiPolygon.call(void 0, unioned);
}
function createMask(mask2) {
  const world = [
    [
      [180, 90],
      [-180, 90],
      [-180, -90],
      [180, -90],
      [180, 90]
    ]
  ];
  let coordinates = world;
  if (mask2) {
    if (mask2.type === "Feature") {
      coordinates = mask2.geometry.coordinates;
    } else {
      coordinates = mask2.coordinates;
    }
  }
  return _helpers.polygon.call(void 0, coordinates);
}
var index_default = mask;



exports.default = index_default; exports.mask = mask;
//# sourceMappingURL=index.cjs.map