"use strict";Object.defineProperty(exports, "__esModule", {value: true});var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};

// index.ts
var _bbox = require('@turf/bbox');
var _area = require('@turf/area');
var _booleanpointinpolygon = require('@turf/boolean-point-in-polygon');
var _explode = require('@turf/explode');
var _invariant = require('@turf/invariant');





var _helpers = require('@turf/helpers');

// lib/grid-to-matrix.js

var _meta = require('@turf/meta');

function gridToMatrix(grid, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  var zProperty = options.zProperty || "elevation";
  var flip = options.flip;
  var flags = options.flags;
  _invariant.collectionOf.call(void 0, grid, "Point", "input must contain Points");
  var pointsMatrix = sortPointsByLatLng(grid, flip);
  var matrix = [];
  for (var r = 0; r < pointsMatrix.length; r++) {
    var pointRow = pointsMatrix[r];
    var row = [];
    for (var c = 0; c < pointRow.length; c++) {
      var point = pointRow[c];
      if (point.properties[zProperty]) row.push(point.properties[zProperty]);
      else row.push(0);
      if (flags === true) point.properties.matrixPosition = [r, c];
    }
    matrix.push(row);
  }
  return matrix;
}
function sortPointsByLatLng(points, flip) {
  var pointsByLatitude = {};
  _meta.featureEach.call(void 0, points, function(point) {
    var lat = _invariant.getCoords.call(void 0, point)[1];
    if (!pointsByLatitude[lat]) pointsByLatitude[lat] = [];
    pointsByLatitude[lat].push(point);
  });
  var orderedRowsByLatitude = Object.keys(pointsByLatitude).map(function(lat) {
    var row = pointsByLatitude[lat];
    var rowOrderedByLongitude = row.sort(function(a, b) {
      return _invariant.getCoords.call(void 0, a)[0] - _invariant.getCoords.call(void 0, b)[0];
    });
    return rowOrderedByLongitude;
  });
  var pointMatrix = orderedRowsByLatitude.sort(function(a, b) {
    if (flip) return _invariant.getCoords.call(void 0, a[0])[1] - _invariant.getCoords.call(void 0, b[0])[1];
    else return _invariant.getCoords.call(void 0, b[0])[1] - _invariant.getCoords.call(void 0, a[0])[1];
  });
  return pointMatrix;
}

// index.ts
function isobands(pointGrid, breaks, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const zProperty = options.zProperty || "elevation";
  const commonProperties = options.commonProperties || {};
  const breaksProperties = options.breaksProperties || [];
  _invariant.collectionOf.call(void 0, pointGrid, "Point", "Input must contain Points");
  if (!breaks) throw new Error("breaks is required");
  if (!Array.isArray(breaks)) throw new Error("breaks is not an Array");
  if (!_helpers.isObject.call(void 0, commonProperties))
    throw new Error("commonProperties is not an Object");
  if (!Array.isArray(breaksProperties))
    throw new Error("breaksProperties is not an Array");
  const matrix = gridToMatrix(pointGrid, { zProperty, flip: true });
  const dx = matrix[0].length;
  if (matrix.length < 2 || dx < 2) {
    throw new Error("Matrix of points must be at least 2x2");
  }
  for (let i = 1; i < matrix.length; i++) {
    if (matrix[i].length !== dx) {
      throw new Error("Matrix of points is not uniform in the x dimension");
    }
  }
  let contours = createContourLines(matrix, breaks, zProperty);
  contours = rescaleContours(contours, matrix, pointGrid);
  const multipolygons = contours.map((contour, index) => {
    if (breaksProperties[index] && !_helpers.isObject.call(void 0, breaksProperties[index])) {
      throw new Error("Each mappedProperty is required to be an Object");
    }
    const contourProperties = __spreadValues(__spreadValues({}, commonProperties), breaksProperties[index]);
    contourProperties[zProperty] = contour[zProperty];
    const multiP = _helpers.multiPolygon.call(void 0, 
      contour.groupedRings,
      contourProperties
    );
    return multiP;
  });
  return _helpers.featureCollection.call(void 0, multipolygons);
}
function createContourLines(matrix, breaks, property) {
  const contours = [];
  let prevSegments;
  for (let i = 1; i < breaks.length; i++) {
    if (i === 1) {
      prevSegments = getSegments(matrix, +breaks[0]);
    }
    const upperBand = +breaks[i];
    const lowerBand = +breaks[i - 1];
    const segments = getSegments(matrix, upperBand);
    const reverseSegments = segments.map(
      (segment) => (
        // note that we (in-place) reverse the array result of .map and not the original segment itself.
        segment.map((pos) => [pos[0], pos[1]]).reverse()
      )
    );
    const rings = assembleRings(prevSegments.concat(reverseSegments), matrix);
    const orderedRings = orderByArea(rings);
    const polygons = groupNestedRings(orderedRings);
    if (polygons.length === 0 && matrix[0][0] < upperBand) {
      const dx = matrix[0].length;
      const dy = matrix.length;
      polygons.push([
        [
          [0, 0],
          [dx - 1, 0],
          [dx - 1, dy - 1],
          [0, dy - 1],
          [0, 0]
        ]
      ]);
    }
    contours.push({
      groupedRings: polygons,
      [property]: lowerBand + "-" + upperBand
    });
    prevSegments = segments;
  }
  return contours;
}
function getSegments(matrix, threshold) {
  const segments = [];
  const dx = matrix[0].length;
  const dy = matrix.length;
  for (let y = 0; y < dy - 1; y++) {
    for (let x = 0; x < dx - 1; x++) {
      const tr = matrix[y + 1][x + 1];
      const br = matrix[y][x + 1];
      const bl = matrix[y][x];
      const tl = matrix[y + 1][x];
      let grid = (tl >= threshold ? 8 : 0) | (tr >= threshold ? 4 : 0) | (br >= threshold ? 2 : 0) | (bl >= threshold ? 1 : 0);
      switch (grid) {
        case 0:
          continue;
        case 1:
          segments.push([
            [x + frac(bl, br), y],
            [x, y + frac(bl, tl)]
          ]);
          break;
        case 2:
          segments.push([
            [x + 1, y + frac(br, tr)],
            [x + frac(bl, br), y]
          ]);
          break;
        case 3:
          segments.push([
            [x + 1, y + frac(br, tr)],
            [x, y + frac(bl, tl)]
          ]);
          break;
        case 4:
          segments.push([
            [x + frac(tl, tr), y + 1],
            [x + 1, y + frac(br, tr)]
          ]);
          break;
        case 5: {
          const avg = (tl + tr + br + bl) / 4;
          const above = avg >= threshold;
          if (above) {
            segments.push(
              [
                [x + frac(tl, tr), y + 1],
                [x, y + frac(bl, tl)]
              ],
              [
                [x + frac(bl, br), y],
                [x + 1, y + frac(br, tr)]
              ]
            );
          } else {
            segments.push(
              [
                [x + frac(tl, tr), y + 1],
                [x + 1, y + frac(br, tr)]
              ],
              [
                [x + frac(bl, br), y],
                [x, y + frac(bl, tl)]
              ]
            );
          }
          break;
        }
        case 6:
          segments.push([
            [x + frac(tl, tr), y + 1],
            [x + frac(bl, br), y]
          ]);
          break;
        case 7:
          segments.push([
            [x + frac(tl, tr), y + 1],
            [x, y + frac(bl, tl)]
          ]);
          break;
        case 8:
          segments.push([
            [x, y + frac(bl, tl)],
            [x + frac(tl, tr), y + 1]
          ]);
          break;
        case 9:
          segments.push([
            [x + frac(bl, br), y],
            [x + frac(tl, tr), y + 1]
          ]);
          break;
        case 10: {
          const avg = (tl + tr + br + bl) / 4;
          const above = avg >= threshold;
          if (above) {
            segments.push(
              [
                [x, y + frac(bl, tl)],
                [x + frac(bl, br), y]
              ],
              [
                [x + 1, y + frac(br, tr)],
                [x + frac(tl, tr), y + 1]
              ]
            );
          } else {
            segments.push(
              [
                [x, y + frac(bl, tl)],
                [x + frac(tl, tr), y + 1]
              ],
              [
                [x + 1, y + frac(br, tr)],
                [x + frac(bl, br), y]
              ]
            );
          }
          break;
        }
        case 11:
          segments.push([
            [x + 1, y + frac(br, tr)],
            [x + frac(tl, tr), y + 1]
          ]);
          break;
        case 12:
          segments.push([
            [x, y + frac(bl, tl)],
            [x + 1, y + frac(br, tr)]
          ]);
          break;
        case 13:
          segments.push([
            [x + frac(bl, br), y],
            [x + 1, y + frac(br, tr)]
          ]);
          break;
        case 14:
          segments.push([
            [x, y + frac(bl, tl)],
            [x + frac(bl, br), y]
          ]);
          break;
        case 15:
          continue;
      }
    }
  }
  return segments;
  function frac(z0, z1) {
    if (z0 === z1) {
      return 0.5;
    }
    let t = (threshold - z0) / (z1 - z0);
    return t > 1 ? 1 : t < 0 ? 0 : t;
  }
}
function assembleRings(segments, matrix) {
  const dy = matrix.length;
  const dx = matrix[0].length;
  const contours = [];
  const result = [];
  while (segments.length > 0) {
    const contour = [...segments.shift()];
    contours.push(contour);
    let found;
    do {
      found = false;
      for (let i = 0; i < segments.length; i++) {
        const segment = segments[i];
        if (segment[0][0] === contour[contour.length - 1][0] && segment[0][1] === contour[contour.length - 1][1]) {
          found = true;
          contour.push(segment[1]);
          segments.splice(i, 1);
          break;
        }
        if (segment[1][0] === contour[0][0] && segment[1][1] === contour[0][1]) {
          found = true;
          contour.unshift(segment[0]);
          segments.splice(i, 1);
          break;
        }
      }
    } while (found);
  }
  while (contours.length > 0) {
    const contour = contours[0];
    if (contour[0][0] === contour[contour.length - 1][0] && contour[0][1] === contour[contour.length - 1][1]) {
      result.push(contour);
      contours.shift();
      continue;
    }
    const end = contour[contour.length - 1];
    let match;
    let corner;
    if (end[0] === 0 && end[1] !== 0) {
      match = getAdjacentContour(
        contours,
        (contour2) => contour2[0][0] === 0 && contour2[0][1] < end[1],
        // left side, below end
        (a, b) => b[0][1] - a[0][1]
        // prefer positions to the top
      );
      corner = [0, 0];
    } else if (end[1] === 0 && end[0] !== dx - 1) {
      match = getAdjacentContour(
        contours,
        (contour2) => contour2[0][1] === 0 && contour2[0][0] > end[0],
        // bottom side, right of end
        (a, b) => a[0][0] - b[0][0]
        // prefer positions to the left
      );
      corner = [dx - 1, 0];
    } else if (end[0] === dx - 1 && end[1] !== dy - 1) {
      match = getAdjacentContour(
        contours,
        (contour2) => contour2[0][0] === dx - 1 && contour2[0][1] > end[1],
        // right side, above end
        (a, b) => a[0][1] - b[0][1]
        // prefer positions to the bottom
      );
      corner = [dx - 1, dy - 1];
    } else if (end[1] === dy - 1 && end[0] !== 0) {
      match = getAdjacentContour(
        contours,
        (contour2) => contour2[0][1] === dy - 1 && contour2[0][0] < end[0],
        // top side, left of end
        (a, b) => b[0][0] - a[0][0]
        // prefer positions to the right
      );
      corner = [0, dy - 1];
    } else {
      throw new Error("Contour not closed but is not along an edge");
    }
    if (match === -1) {
      contour.push(corner);
    } else if (match === 0) {
      contour.push([contour[0][0], contour[0][1]]);
      result.push(contour);
      contours.shift();
    } else {
      const matchedContour = contours[match];
      contours.splice(match, 1);
      for (const p of matchedContour) {
        contour.push(p);
      }
    }
  }
  for (let i = 0; i < result.length; i++) {
    if (result[i].length < 4) {
      result.splice(i, 1);
      i--;
    }
  }
  return result;
}
function rescaleContours(contours, matrix, points) {
  const gridBbox = _bbox.bbox.call(void 0, points);
  const originalWidth = gridBbox[2] - gridBbox[0];
  const originalHeigth = gridBbox[3] - gridBbox[1];
  const x0 = gridBbox[0];
  const y0 = gridBbox[1];
  const matrixWidth = matrix[0].length - 1;
  const matrixHeight = matrix.length - 1;
  const scaleX = originalWidth / matrixWidth;
  const scaleY = originalHeigth / matrixHeight;
  return contours.map(function(contour) {
    contour.groupedRings = contour.groupedRings.map(
      function(lineRingSet) {
        return lineRingSet.map(function(lineRing) {
          return lineRing.map((point) => [
            point[0] * scaleX + x0,
            point[1] * scaleY + y0
          ]);
        });
      }
    );
    return contour;
  });
}
function orderByArea(ringsCoords) {
  const ringsWithArea = ringsCoords.map(function(coords) {
    return { ring: coords, area: _area.area.call(void 0, _helpers.polygon.call(void 0, [coords])) };
  });
  ringsWithArea.sort(function(a, b) {
    return b.area - a.area;
  });
  return ringsWithArea.map(function(x) {
    return x.ring;
  });
}
function groupNestedRings(orderedLinearRings) {
  const lrList = orderedLinearRings.map((lr) => {
    return { lrCoordinates: lr, grouped: false };
  });
  const groupedLinearRingsCoords = [];
  while (!allGrouped(lrList)) {
    for (let i = 0; i < lrList.length; i++) {
      if (!lrList[i].grouped) {
        const group = [];
        group.push(lrList[i].lrCoordinates);
        lrList[i].grouped = true;
        const outerMostPoly = _helpers.polygon.call(void 0, [lrList[i].lrCoordinates]);
        OUTER: for (let j = i + 1; j < lrList.length; j++) {
          if (!lrList[j].grouped) {
            const lrPoly = _helpers.polygon.call(void 0, [lrList[j].lrCoordinates]);
            if (isInside(lrPoly, outerMostPoly)) {
              for (let k = 1; k < group.length; k++) {
                if (isInside(lrPoly, _helpers.polygon.call(void 0, [group[k]]))) {
                  continue OUTER;
                }
              }
              group.push(lrList[j].lrCoordinates);
              lrList[j].grouped = true;
            }
          }
        }
        groupedLinearRingsCoords.push(group);
      }
    }
  }
  return groupedLinearRingsCoords;
}
function isInside(testPolygon, targetPolygon) {
  const points = _explode.explode.call(void 0, testPolygon);
  for (let i = 0; i < points.features.length; i++) {
    if (!_booleanpointinpolygon.booleanPointInPolygon.call(void 0, points.features[i], targetPolygon)) {
      return false;
    }
  }
  return true;
}
function allGrouped(list) {
  for (let i = 0; i < list.length; i++) {
    if (list[i].grouped === false) {
      return false;
    }
  }
  return true;
}
function getAdjacentContour(contours, test, sort) {
  let match = -1;
  for (let j = 0; j < contours.length; j++) {
    if (test(contours[j])) {
      if (match === -1 || sort(contours[match], contours[j]) > 0) {
        match = j;
      }
    }
  }
  return match;
}
var index_default = isobands;



exports.default = index_default; exports.isobands = isobands;
//# sourceMappingURL=index.cjs.map