import BScroll from '@better-scroll/core';
import { IndicatorOptions, Postion, ValueSign } from './types';
import { EventRegister, EventEmitter } from '@better-scroll/shared-utils';
export default class Indicator {
    scroll: BScroll;
    options: IndicatorOptions;
    wrapper: HTMLElement;
    indicatorEl: HTMLElement;
    maxScrollX: number;
    minScrollX: number;
    ratioX: number;
    maxScrollY: number;
    minScrollY: number;
    translateXSign: ValueSign;
    translateYSign: ValueSign;
    ratioY: number;
    currentPos: Postion;
    moved: boolean;
    startTime: number;
    initiated: boolean;
    lastPointX: number;
    lastPointY: number;
    startEventRegister: EventRegister;
    moveEventRegister: EventRegister;
    endEventRegister: EventRegister;
    hooksFn: [EventEmitter, string, Function][];
    constructor(scroll: BScroll, options: IndicatorOptions);
    private handleDOM;
    private handleHooks;
    private transitionTime;
    private transitionTimingFunction;
    private handleInteractive;
    private registerHooks;
    private registerEvents;
    refresh(): void;
    private start;
    private BScrollIsDisabled;
    private move;
    private end;
    private getBScrollPosByRatio;
    private indicatorNotMoved;
    private syncBScroll;
    updatePosition(BScrollPos: Postion): void;
    private applyTransformProperty;
    private getIndicatorPosByRatio;
    destroy(): void;
}
