import Vue from "vue";
import Router from "vue-router";
import store from './store'
import Home from "./views/Home.vue";
//软件列表
import SoftwareList from "./views/SoftwareList/SoftwareList.vue";
//特权用户信息
import UserInfo from "./views/UserInfo.vue";
// 系统信息
import SystemInfo from "./views/System/SystemInfo.vue"
//软件详情
import SoftwareDetails from "./views/SoftwareList/SoftwareDetails.vue";
//基本信息
import BaseicInformation from "./components/BaseicInformation/BaseicInformation.vue";
//常用工具
import CommonTool from "./components/CommonTool/CommonTool.vue";
//常用工具---角色
import RolesList from "./components/CommonTool/RolesList.vue";
import Roles from "./components/CommonTool/Roles.vue";
//常用工具---pc菜单
import PcMenu from "./components/CommonTool/PcMenu.vue";
//常用工具---mobile菜单
import MobileMenu from "./components/CommonTool/MobileMenu.vue";
//常用工具---widget
import WidgetList from "./components/CommonTool/WidgetList.vue";
//常用工具---任务
import TaskList from "./components/CommonTool/TaskList.vue";
import Task from "./components/CommonTool/Task.vue";
//常用工具---状态标签
import StatusLabelList from "./components/CommonTool/StatusLabelList.vue";
import StatusLabel from "./components/CommonTool/StatusLabel.vue";

//高级工具
import AdvancedTool from "./components/AdvancedTool/AdvancedTool.vue";
//高级工具---开发者
import Developer from "./components/AdvancedTool/Developer.vue";
//高级工具---Excel导入配置
import ExcelConf from "./components/AdvancedTool/ExcelConf.vue";
//高级工具---api中心
import APIInterfaceList from "./components/AdvancedTool/APIInterfaceList.vue";
//高级工具---api中心详情
import APIInterface from "./components/AdvancedTool/APIInterface.vue";
//高级工具---Eip
import Eip from "./components/AdvancedTool/Eip.vue";
//高级工具---数据源列表
import DataSourceList from "./components/AdvancedTool/DataSourceList.vue";
//高级工具---数据源列表
import DataSource from "./components/AdvancedTool/DataSource.vue";
//高级工具---元数据管理
import MetadataMgr from "./components/AdvancedTool/MetadataMgr.vue";

//库
import Library from "./components/Library/Library.vue";
//库---函数库
import MacroLibsList from "./components/Library/MacroLibsList.vue";
//库---函数库详情
import MacroLibs from "./components/Library/MacroLibs.vue";
//库---样式库
import StyleLibsList from "./components/Library/StyleLibsList.vue";
//库---样式库详情
import StyleLibs from "./components/Library/StyleLibs.vue";
//库---校验库
import ValidateLibsList from "./components/Library/ValidateLibsList.vue";
//库---校验库详情
import ValidateLibs from "./components/Library/ValidateLibs.vue";

//多语言
import MultiLanguageList from "./components/MultiLanguage/MultiLanguageList.vue";
//多语言详情
import MultiLanguage from "./components/MultiLanguage/MultiLanguage.vue";

//平台模式-回调信息
import CbInfo from "./components/CbInfo/CbInfo.vue";


//模块
//基本信息
import BasicInfor from "./components/Modules/BasicInfor.vue";
//表单
import FormList from "./components/Modules/FormList.vue";
import Form from "./components/Modules/Form.vue";
//视图
import ViewList from "./components/Modules/ViewList.vue";
import View from "./components/Modules/View.vue";
//流程
import ProcessList from "./components/Modules/ProcessList.vue";
//统计图
import ChartsList from "./components/Modules/ChartsList.vue";
import Charts from "./components/Modules/Charts.vue";
//报表
import ReportsList from "./components/Modules/ReportsList.vue";
import Reports from "./components/Modules/Reports.vue";
// 页面
import PageList from "./components/Modules/PageList.vue";
import Page from "./components/Modules/Page.vue";

Vue.use(Router);

const router = new Router({
  mode: "hash",
  routes: [
    {
      path: "/",
      redirect: "/login",
    },
    {
      path: "/login",
      name: "login",
      component: () => import(/* webpackChunkName: "login" */ "./views/Login.vue"),
    },
    {
      path: "/test",
      name: "test",
      component: () => import(/* webpackChunkName: "login" */ "./views/test.vue"),
    },
    {
      path: "/home",
      name: "home",
      // redirect:'/home/softwarelist',
      component: Home,
      // meta: {
      //   keepAlive: true,//此组件需要被缓存
      //   title: "",
      // },
      children: [
        {
          path: "softwarelist",
          name: "SoftwareList", //软件列表
          component: SoftwareList,
        },
        {
          path: "userinfo",
          name: "UserInfo", //特权用户信息
          component: UserInfo,
        },
        {
          path: "systemInfo",
          name: "systemInfo", // 系统信息
          component: SystemInfo,
        },
        {
          path: "softwaresdetails",
          name: "sofstwasredetails", //软件详情
          component: SoftwareDetails,
          meta: { requiresAuth: true },
          children: [
            {
              path: "baseicinfor",
              name: "baseicinfor", //基本信息
              component: BaseicInformation,
            },
            {
              path: "commontool",
              name: "commontool", //常用工具
              component: CommonTool,
              meta: { requiresAuth: true },
              children: [
                {
                  path: "roleslist",
                  name: "roleslist", //角色列表
                  component: RolesList,
                },
                {
                  path: "roles",
                  name: "roles", //角色表单
                  component: Roles,
                },
                {
                  path: "pcmenu",
                  name: "pcMenu", //pc菜单
                  component: PcMenu,
                },
                {
                  path: "mobilemenu",
                  name: "mobileMenu", //mobile菜单
                  component: MobileMenu,
                },
                {
                  path: "widgetlist",
                  name: "widgetlist", //Widget列表
                  component: WidgetList,
                },
                {
                  path: "tasklist",
                  name: "tasklist", //任务列表
                  component: TaskList,
                },
                {
                  path: "task",
                  name: "task", //任务表单
                  component: Task,
                },
                {
                  path: "statuslabellist",
                  name: "statuslabellist", //状态标签列表
                  component: StatusLabelList,
                },
                {
                  path: "statuslabel",
                  name: "statuslabel", //状态标签表单
                  component: StatusLabel,
                },
              ],
            },
            {
              path: "advancedTool",
              name: "advancedTool", //高级工具
              component: AdvancedTool,
              meta: { requiresAuth: true },
              children: [
                {
                  path: "developer",
                  name: "developer", //开发者
                  component: Developer,
                },
                {
                  path: "excelConf",
                  name: "excelConf", //Excel导入配置
                  component: ExcelConf,
                },
                {
                  path: "apiInterfaceList",
                  name: "apiInterfaceList", //api中心列表
                  component: APIInterfaceList,
                },
                {
                  path: "apiInterface",
                  name: "apiInterface", //api中心详情
                  component: APIInterface,
                },
                {
                  path: "eip",
                  name: "eip", //Excel导入配置
                  component: Eip,
                },
                {
                  path: "dataSourceList",
                  name: "dataSourceList", //数据源列表
                  component: DataSourceList,
                },
                {
                  path: "dataSource",
                  name: "dataSource", //数据源详情
                  component: DataSource,
                },
                {
                  path: "metadataMgr",
                  name: "metadataMgr", //元数据管理
                  component: MetadataMgr,
                },
              ],
            },
            {
              path: "library",
              name: "library", //库
              component: Library,
              meta: { requiresAuth: true },
              children: [
                {
                  path: "macroLibsList",
                  name: "macroLibsList", //函数库
                  component: MacroLibsList,
                },
                {
                  path: "macroLibs",
                  name: "macroLibs", //函数库详情
                  component: MacroLibs,
                },
                {
                  path: "styleLibsList",
                  name: "styleLibsList", //样式库
                  component: StyleLibsList,
                },
                {
                  path: "styleLibs",
                  name: "styleLibs", //样式库详情
                  component: StyleLibs,
                },
                {
                  path: "validateLibsList",
                  name: "validateLibsList", //校验库
                  component: ValidateLibsList,
                },
                {
                  path: "validateLibs",
                  name: "validateLibs", //校验库详情
                  component: ValidateLibs,
                },
              ],
            },
            {
              path: "multiLanguageList",
              name: "multiLanguageList", //多语言
              component: MultiLanguageList,
              meta: { requiresAuth: true },
            },
            {
              path: "multiLanguage",
              name: "multiLanguage", //多语言详情
              component: MultiLanguage,
              meta: { requiresAuth: true },
            },
            {
              path: "cbInfo",
              name: "cbInfo", //多语言
              component: CbInfo,
            },
            //模块 BasicInfor
            {
              path: "basicinfor",
              name: "basicinfor", //模块---基本信息
              component: BasicInfor,
              meta: { requiresAuth: true },
            },
            {
              path: "formlist",
              name: "formlist", //模块---表单列表
              component: FormList,
              meta: { requiresAuth: true },
            },
            {
              path: "form",
              name: "forms", //模块---表单
              component: Form,
              meta: { requiresAuth: true },
            },
            {
              path: "viewlist",
              name: "viewlist", //模块---视图列表
              component: ViewList,
              meta: { requiresAuth: true },
            },
            {
              path: "View",
              name: "View",
              component: View,
              meta: { requiresAuth: true },
            },
            {
              path: "processlist",
              name: "processlist", //模块---流程列表
              component: ProcessList,
              meta: { requiresAuth: true },
            },
            {
              path: "chartslist",
              name: "chartslist", //模块---统计图列表
              component: ChartsList,
              meta: { requiresAuth: true },
            },
            {
              path: "charts",
              name: "charts", //模块---统计图列表
              component: Charts,
              meta: { requiresAuth: true },
            },
            {
              path: "reportslist",
              name: "reportslist", //模块---报表列表
              component: ReportsList,
              meta: { requiresAuth: true },
            },
            {
              path: "reports",
              name: "reports", //模块---报表
              component: Reports,
              meta: { requiresAuth: true },
            },
            {
              path: "pagelist",
              name: "pagelist", //模块---页面列表
              component: PageList,
              meta: { requiresAuth: true },
            },
            {
              path: "page",
              name: "page", //模块---页面
              component: Page,
              meta: { requiresAuth: true },
            },
          ],
        },
        {
          path: "/home/baseicinformation",
          name: "baseicinformation", //创建软件
          component: BaseicInformation,
        },
      ],
    },
  ],
});

// 路由拦截
router.beforeEach((to, from, next) => {
  // 如果用户访问的登录页，直接放行
  if (to.path === '/login') return next()
  // 如果用户访问的后台管理页面，需要先判断是否有token
  const tokenStr = window.sessionStorage.getItem('token')
  if (!tokenStr) return next('/login')
  next()
  store.commit('changeIsClickPrimaryTab', to.name + new Date().getTime());

})

export default router;
