import Sequence from '../utility/Sequence';

class Element {
    constructor(diagram){
        this._owner = diagram;
        this.scale = 0;
        this.id = Sequence.getSequence() + "";
        this.name = "";
        this.description = "";
        this.bgcolor = Element.DEF_BGCOLOR;
        this.color = Element.DEF_COLOR;
        this.font = Element.DEF_FONT;
        this._subelems = [];

    }

    toXML() {
        let str = '';
    
        str += '<id>' + this.replaceCharacter(this.id) + '</id>\n';
        str += '<name>' + this.replaceCharacter(this.name) + '</name>\n';
    
        return str;
      }
    
    // 替换特殊字符
    replaceCharacter(str) {
    if (str != null) {
        while (str.indexOf('&') != -1 || str.indexOf('"') != -1 || str.indexOf('<') != -1 || str.indexOf('>') != -1) {
        str = str.replace(/&/g, '@amp;');
        str = str.replace(/\"/g, '@quot;');
        str = str.replace(/</g, '@lt;');
        str = str.replace(/>/g, '@gt;');
        }
        return str;
    }
    return '';
    }

    replaceXML(str) {
    if (str != null) {
        while (str.indexOf('"') != -1) {
        str = str.replace(/\"/g, '@quot;');
        }
        return str;
    }
    return '';
    }

    appendElement(e) {
		this._subelems.push(e);
	}



    getSubelems() {
        return this._subelems;
      }

    
}

Element.DEF_SELECTEDCOLOR = 'pink';
Element.DEF_CURREDITCOLOR = 'red';
Element.DEF_BGCOLOR = 'rgb(128, 255, 128)';
Element.DEF_COLOR = 'black';
Element.DEF_PASSEDCOLOR = 'green';
Element.DEF_FONT = '"宋体", 0, 10';


export default Element