import instance from './ajax';

/**
 * 高级工具模块
 * 获取开发者列表
 */
export const getDeveloperList = (params, appId,) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId + '/superusers/join?name='+ params.name+`&loginno=${params.loginno}&pageNo=${params.pageNo}&linesPerPage=${params.linesPerPage}`,
    method: 'get',
  })
}
/**
 * 删除开发者（可批量）
 */
export const deleteDeveloperList = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/superusers',
    method: 'delete',
    data
  })
}
/**
 * 对话框展示添加数据列表
 * 
 */
export const getDialogDeveloperList = (params, appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId + '/superusers/unjoin?name='+ params.name+`&loginno=${params.loginno}&pageNo=${params.pageNo}&linesPerPage=${params.linesPerPage}`,
    method: 'get',
  })
}
/**
 * 对话框添加数据
 * 
 */
export const addDialogDeveloperData = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/superusers',
    method: 'post',
    data,
  })
}
/**
 * Excel导入配置获取列表
 * 
 */
export const getExcelConfList = (params,appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/excelconfigs?name='+ params.inputName + '&pageNo='+ params.currpage + '&linesPerPage='+ params.pagelines,
    method: 'get',
  })
}
/**
 * 删除Excel导入配置（可批量）
 */
export const deleteExcelConfList = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/excelconfigs',
    method: 'delete',
    data
  })
}
/**
 * 更新excel导入配置
 */
export const updataExcelConf = (data,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/excelconfigs`,
    method: 'put',
    data
  })
}
/**
 * 获取eip列表（可根据名字查询）
 * 
 */
export const getEipList = (params,appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/eips?name='+ params.inputName + '&currpage='+ params.currpage + '&pagelines='+ params.pagelines,
    method: 'get',
  })
}

/**
 * 新建eip
 */
export const createEip = (data,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/eips`,
    method: 'post',
    data
  })
}
/**
 * 更新eip
 */
export const updataEip = (data,eipId,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/eips/${eipId}`,
    method: 'put',
    data
  })
}
/**
 * 删除Excel导入配置（可批量）
 */
export const deleteEipList = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/eips',
    method: 'delete',
    data
  })
}

/**
 * 获取api列表
 * @param {*} params 
 * @param {*} appId 
 * @returns 
 */
export const getAPISList = (params,appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/apis?name='+ params.name + '&requestType=' + params.requestType + '&pageNo='+ params.pageNo + '&linesPerPage='+ params.linesPerPage,
    method: 'get',
  })
}

/**
 * 获取api详情
 * @param {*} params 
 * @param {*} appId 
 * @returns 
 */
export const getAPISDetail = (apiId) => {
  return instance({
    url: contextPath + `/designtime/applications/apis/${apiId}`,
    method: 'get',
  })
}


/**
 * 新建api
 */
export const createApi = (data,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/apis`,
    method: 'post',
    data
  })
}

/**
 * 更新api
 */
export const updateApi = (data,apiId,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/apis/${apiId}`,
    method: 'put',
    data
  })
}

/**
 * 删除api（可批量）
 */
export const deleteApiList = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/apis',
    method: 'delete',
    data
  })
}

/**
 * 获取api分组
 * @param {*} params 
 * @param {*} appId 
 * @returns 
 */
 export const getAPISGroup = (params,appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/apigroups?name='+ params.name + '&currpage='+ params.pageNo + '&pagelines='+ params.linesPerPage,
    method: 'get',
  })
}

/**
 * 新建api分组
 */
 export const createApiGroup = (data,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/apigroups`,
    method: 'post',
    data
  })
}

/**
 * 更新api
 */
 export const updateApiGroup = (data,apiGroupId,applicationId) => {
  return instance({
    url: contextPath + `/designtime/applications/${applicationId}/apigroups/${apiGroupId}`,
    method: 'put',
    data
  })
}

/**
 * 删除api分组（可批量）
 */
 export const deleteApiGroup = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/apigroups',
    method: 'delete',
    data
  })
}

/**
 * 数据源获取列表
 * 
 */
export const getDataSourceList = (params,appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/datasources?name='+ params.searchword + '&pageNo='+ params.pageNo + '&linesPerPage='+ params.pagelines,
    method: 'get',
  })
}
/**
 * 删除Excel导入配置（可批量）
 */
export const deleteDataSourceList = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/datasources',
    method: 'delete',
    data
  })
}

/**
 * 新建数据源保存
 */
export const saveDataSource = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/datasources',
    method: 'post',
    data
  })
}

/**
 * 更新数据源保存
 */
export const updateDataSource = (appId,dataSourceId, data) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/${dataSourceId}`,
    method: 'put',
    data
  })
}


/**
 * 测试数据库
 */
export const testDataSource = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/testdatasources',
    method: 'post',
    data
  })
}
/**
 * 获取数据源详情
 */
export const getDataSource = (appId,dataSourceId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/datasources/'+ dataSourceId,
    method: 'get',
  })
}

/**
 * 脚本预编译
 */
export const scriptPrecompilation = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/iscript/compile',
    method: 'post',
    data
  })
}
/**
 * 脚本帮助文档
 */
export const scriptHelpInterface = () => {
  return instance({
    url: contextPath + '/designtime/applications/iscript/getIscriptHelp?staticPath=' + staticPath,
    method: 'get',
  })
}
/**
 * 高级工具模块
 * 获取元数据列表
 */
export const getMetadataList = (params,appId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/getMetadata?datasourceId=${params.datasourceId}&subNodes=${params.subNodes}`,
    method: 'get',
  })
}
/**
 * 高级工具模块
 * 获取元数据索引列表
 */
export const getIndexManager = (id,appId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/getIndex?datasourceId=${id}`,
    method: 'get',
  })
}
/**
 * 高级工具模块
 * 优化索引
 */
export const optimization = (appId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/optimization`,
    method: 'get',
  })
}
/**
 * 高级工具模块
 * 获取表信息
 */
export const getTable = (params,appId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/getTable?datasourceId=${params.datasourceId}&formId=${params.formId}`,
    method: 'get',
  })
}
/**
 * 高级工具模块
 * 同步表单字段
 */
export const synFormTable = (params,appId) => {
  return instance({
    url: contextPath + `/designtime/applications/${appId}/datasources/synFormTable?datasourceId=${params.datasourceId}&formId=${params.formId}`,
    method: 'get',
  })
}