import TextElement from './TextElement';
import {Sequence, Archor} from '../../utility';
class Chart extends TextElement {
	constructor() {
		super();
		this.chartDateNull=true;
		this.backcolor="#ffffff";
		this.mode="Transparent";
		this.text = Chart.DEF_TEXT; //当前元素默认文本
		this.key="图表";
		this.belong = '';
		this.isOpenArchor = false;
		this.width=100;
		this.height=100;
		this.chartType="";
		this.chartTypeChina="";
		this.src="";
		this.srcT='images/auto.gif';

		this.chartDate={};
		this.evaluationTime="Now";
		this.isShowLegend=true;
		this.title="";
		this.titlePosition="Top";
		this.titleFontColor="#000";
		this.titleFontName="SansSerif";
		this.titleFontSize=8;
		this.subtitle="";
		this.subtitleFontColor="#000000";
		this.subtitleFontName="SansSerif";
		this.subtitleFontSize=8;
		this.legendColor="#000000";
		this.legendBgColor="#ffffff";
		this.legendPosition="Bottom";
		this.legendFontName="SansSerif";
		this.legendFontSize=8;
		this.renderType="draw";
		this.keyExpression="";
		this.valueExpression="";
		this.labelExpression="";
		this.orientation="Vertical";
		this.resetType="Report";

		this.pieCircular=true;
        this.pielegendLabelFormat="{0}";

		this.isShowLines=true;
		this.isShowShapes=true;

        this.categoryAxisLabelExpression="";
		this.valueAxisLabelExpression="";
		this.categoryVerticalTickLabels=false;
		this.valueVerticalTickLabels=false;

		this.labelFormat="{0}";
		this.labelFontName="SansSerif";
        this.labelFontSize=8;
        this.labelFontColor="#000000"
		this.seriesArr=[];
		this.isShowLabels=true;
		this.lineWidth=0;

		this.rangeAxisMinValueExpression;
		this.rangeAxisMaxValueExpression;

	}
	
	getClassName() {
		return 'Chart';
	}

	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		node.src=this.src;
		node.icon = 'glyphicon glyphicon-music';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		//console.log(this)
		const that=this;
		
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		g.save();	
		g.setColor(this.backcolor);
		g.setLineWidth(0.5);
		if(this.mode == 'Opaque') {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.fillRect(this.x+this.lineWidth*(5/2), this.y+this.lineWidth*(5/2), this.width-this.lineWidth*5, this.height-this.lineWidth*5);
			}else{
				g.fillRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth);
			}

			//g.fillRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth);

		} else {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			g.drawRect(this.x,this.y,this.width,this.height)
			//g.stroke();
			//g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				//g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.drawRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4,this.radius);
				//g.stroke();
			}
			//g.strokeRect(this.x+this.lineWidth, this.y+this.lineWidth, this.width-this.lineWidth*2, this.height-this.lineWidth*2);
		}
		g.setLineStyle();
		g.restore();
		
		
		// let have=this.CheckImgExists(this.src);
		let img = new Image();
		img.onload = function(){
			g.drawImage(img,that.x+1,that.y+1,that.width-2,that.height-2);
		}
		if(this.src!=""){
			img.src = this.src ;
		}else{
			img.src='../reportHtml/images/PieChart.png';
		}

		// console.log(img)
		//g.drawTextWithRow(this.text, tx, ty, this.width, parseInt(this.font.size));
		if(this.error){
			let img2=new Image();
			img2.src=this.errorImgSrc;
			img2.onload=function(){
				g.drawImage(img2,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
		
		
	}
	

	toXML() {
        if(this.labelExpression==""){
            this.labelExpression=this.keyExpression;
        }

		let str = "<"+this.chartType+"Chart>\n";
		str +="<chart isShowLegend=\""+this.isShowLegend+"\" evaluationTime=\""+this.evaluationTime+"\" renderType=\""+this.renderType+"\">\n"
		str += super.toXML2();

		str +="<box>\n"
		str +="<pen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<topPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<leftPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<bottomPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<rightPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="</box>\n"


		str +="<chartTitle position=\""+this.titlePosition+"\" color=\""+this.titleFontColor+"\">\n"
		str +="<font fontName=\""+this.titleFontName+"\" size=\""+this.titleFontSize+"\"/>\n"
		str +="<titleExpression><![CDATA["+this.title+"]]></titleExpression>"
		str +="</chartTitle>\n"

		str +="<chartSubtitle color=\""+this.subtitleFontColor+"\">\n"
		str +="<font fontName=\""+this.subtitleFontName+"\" size=\""+this.subtitleFontSize+"\"/>\n"
		str +="<subtitleExpression><![CDATA["+this.subtitle+"]]></subtitleExpression>"
		str +="</chartSubtitle>\n"

		str +="<chartLegend textColor=\""+this.legendColor+"\" backgroundColor=\""+this.legendBgColor+"\" position=\""+this.legendPosition+"\">\n"
		str +="<font fontName=\""+this.legendFontName+"\" size=\""+this.legendFontSize+"\"/>\n"
		str +="</chartLegend>\n"

		str +="</chart>\n"

		if(this.chartType=="pie"){

			str +="<pieDataset>\n";
			str +="<dataset resetType=\""+this.resetType+"\"/>\n"
			if(this.seriesArr.length>0){
                this.chartDateNull=true;
				str +="<keyExpression><![CDATA["+this.seriesArr[0].key+"]]></keyExpression>\n"
				str +="<valueExpression><![CDATA["+this.seriesArr[0].value+"]]></valueExpression>\n"
				if(this.seriesArr[0].label!=""){
					str +="<labelExpression><![CDATA["+this.seriesArr[0].label+"]]></labelExpression>\n"
				}
			}else{

                this.chartDateNull=false;
			}


			str +="</pieDataset>\n"
			str +="<piePlot legendLabelFormat=\""+this.pielegendLabelFormat+ "\" labelFormat=\""+this.labelFormat+ "\" isShowLabels=\""+this.isShowLabels+ "\" isCircular=\""+true+"\">\n";
			if(this.orientation==null){
				this.orientation="Vertical";
			}
			str +="<plot orientation=\""+this.orientation+"\"/>\n";
			str +="<itemLabel color=\""+this.labelFontColor+"\">\n"
            str +="<font fontName=\""+this.labelFontName+"\" size=\""+this.labelFontSize+"\"/>\n"
            str +="</itemLabel>\n";
			str +="</piePlot>\n";
		}else{

			if(this.seriesArr.length>0){
                this.chartDateNull=true;
				str +="<categoryDataset>\n"
				str +="<dataset resetType=\""+this.resetType+"\"/>\n"
				this.seriesArr.forEach(function(val,ind){
					str +="<categorySeries>\n";
					str +="<seriesExpression><![CDATA["+val.series+"]]></seriesExpression>\n"
					str +="<categoryExpression><![CDATA["+val.category+"]]></categoryExpression>\n"
					str +="<valueExpression><![CDATA["+val.valBar+"]]></valueExpression>\n"
					if(val.labelBar!=""){
						str +="<labelExpression><![CDATA["+val.labelBar+"]]></labelExpression>\n"
					}
					str +="</categorySeries>\n"
				})
				str +="</categoryDataset>\n"
			}else{
                this.chartDateNull=false;
			}


			if(this.chartType=="bar"){
				str +="<"+this.chartType+"Plot isShowLabels=\""+this.isShowLabels+"\">\n"
			}else if(this.chartType="line"){
				str +="<"+this.chartType+"Plot isShowLines=\""+this.isShowLines+"\""+" isShowShapes=\""+this.isShowShapes+"\">\n"
			}else{
				str +="<"+this.chartType+"Plot>\n"
			}
			if(this.orientation==null){
				this.orientation="Vertical";
			}
			str +="<plot orientation=\""+this.orientation+"\"/>\n";
			if(this.chartType=="bar"){
				str +="<itemLabel color=\""+this.labelFontColor+"\">\n"
				str +="<font fontName=\""+this.labelFontName+"\" size=\""+this.labelFontSize+"\"/>\n"
				str +="</itemLabel>\n"
			}

			str +="<categoryAxisLabelExpression><![CDATA["+this.categoryAxisLabelExpression+"]]></categoryAxisLabelExpression>\n"
			str +="<categoryAxisFormat>\n"
			str +="<axisFormat verticalTickLabels=\""+this.categoryVerticalTickLabels+"\">\n"
			str +="</axisFormat>\n"
			str +="</categoryAxisFormat>\n"

			str +="<valueAxisLabelExpression><![CDATA["+this.valueAxisLabelExpression+"]]></valueAxisLabelExpression>\n"
			str +="<valueAxisFormat>\n"
			str +="<axisFormat verticalTickLabels=\""+this.valueVerticalTickLabels+"\">\n"
			str +="</axisFormat>\n"
			str +="</valueAxisFormat>\n"
			if(this.rangeAxisMinValueExpression){
				str +="<rangeAxisMinValueExpression><![CDATA["+this.rangeAxisMinValueExpression+"]]></rangeAxisMinValueExpression>\n"
			}
			if(this.rangeAxisMaxValueExpression){
				str +="<rangeAxisMaxValueExpression><![CDATA["+this.rangeAxisMaxValueExpression+"]]></rangeAxisMaxValueExpression>"
			}

			str +="</"+this.chartType+"Plot>\n"
		}



		str += "</"+this.chartType+"Chart>\n";
		
		return str;
	}
	
	parseXML(xmlNode) {
		let props = {};
		let that=this;
		props.seriesArr=[]
		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'chart':
					that.evaluationTime=xmlNode.getAttribute("evaluationTime");

					that.isShowLegend=xmlNode.getAttribute("isShowLegend");
					const traversalNode2 = (xmlNode) => {
						//console.log(xmlNode);
						const { tagName } = xmlNode;
						//console.log(tagName);

						switch (tagName) {
							case 'reportElement':
								const reportElement = this.handleReportElement(xmlNode);
								Object.assign(props, reportElement);
								break;
							// case 'printWhenExpression':
							// 	props.printWhenExpression=xmlNode.getElementsByTagName("printWhenExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
							//
							// 	break;
							case 'chartTitle':
								props.titlePosition=xmlNode.getAttribute("position");
								props.titleFontColor=xmlNode.getAttribute("color");
								props.titleFontName=xmlNode.getElementsByTagName("font")[0].getAttribute("fontName");
								props.titleFontSize=xmlNode.getElementsByTagName("font")[0].getAttribute("size");
								props.title=xmlNode.getElementsByTagName("titleExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								break;
							case 'chartSubtitle':

								props.subtitleFontColor=xmlNode.getAttribute("color");
								props.subtitleFontName=xmlNode.getElementsByTagName("font")[0].getAttribute("fontName");
								props.subtitleFontSize=xmlNode.getElementsByTagName("font")[0].getAttribute("size");
								props.subtitle=xmlNode.getElementsByTagName("subtitleExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								break;
							case 'chartLegend':

								props.legendColor=xmlNode.getAttribute("textColor");
								props.legendBgColor=xmlNode.getAttribute("backgroundColor");
								props.legendPosition=xmlNode.getAttribute("position");
								props.legendFontName=xmlNode.getElementsByTagName("font")[0].getAttribute("fontName");
								props.legendFontSize=xmlNode.getElementsByTagName("font")[0].getAttribute("size");

								break;
							case 'box':
								props.lineWidth=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineWidth")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineWidth"):0;
								props.lineColor=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineColor")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineColor"):"#000000";
								props.lineStyle=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineStyle")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineStyle"):"solid";
								break;

							default:
								break;
						}
					};
					if(xmlNode.hasChildNodes()) {
						for(let i = 0, len = xmlNode.children.length;i < len;i++) {
							traversalNode2(xmlNode.children[i]);
						}
					}
					break;
				case 'pieDataset':
                    props.resetType=xmlNode.getElementsByTagName("dataset")[0].getAttribute("resetType");
					let keyExpression=xmlNode.getElementsByTagName("keyExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
					let valueExpression=xmlNode.getElementsByTagName("valueExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
					let labelExpression="";
					if(xmlNode.getElementsByTagName("labelExpression").length>0){
						labelExpression=xmlNode.getElementsByTagName("labelExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
					}

					let arr={
						key:keyExpression,
						value:valueExpression,
						label:labelExpression,

					}

					props.seriesArr.push(arr);
					break;
				case 'categoryDataset':

					// props.resetType=xmlNode.getElementsByTagName("dataset")[0].getAttribute("resetType");
					const traversalNode4 = (xmlNode) => {
						//console.log(xmlNode);
						const { tagName } = xmlNode;
						//console.log(tagName);

						switch (tagName) {
							case 'dataset':
								props.resetType=xmlNode.getAttribute("resetType");
								break;
							case 'categorySeries':
								let seriesExpression=xmlNode.getElementsByTagName("seriesExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								let categoryExpression=xmlNode.getElementsByTagName("categoryExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								let valueExpression=xmlNode.getElementsByTagName("valueExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								let labelExpression="";
								if(xmlNode.getElementsByTagName("labelExpression").length>0){
									labelExpression=xmlNode.getElementsByTagName("labelExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
								}
								let arr={
									series:seriesExpression,
									category:categoryExpression,
									valBar:valueExpression,
									labelBar:labelExpression,
								}

								props.seriesArr.push(arr);
								break;
							default:
								break;
						}
					};
					if(xmlNode.hasChildNodes()) {
						for(let i = 0, len = xmlNode.children.length;i < len;i++) {
							traversalNode4(xmlNode.children[i]);
						}
					}
					break;
                case this.chartType+'Plot':
                	if(tagName=="piePlot"){
						props.pielegendLabelFormat=xmlNode.getAttribute("legendLabelFormat")
						props.labelFormat=xmlNode.getAttribute("labelFormat")
						//props.pieCircular=xmlNode.getAttribute("isCircular")
						props.isShowLabels=xmlNode.getAttribute("isShowLabels")
						const traversalNode3 = (xmlNode) => {
							//console.log(xmlNode);
							const { tagName } = xmlNode;
							//console.log(tagName);

							switch (tagName) {
								case 'plot':
									props.orientation=xmlNode.getAttribute("orientation");
									break;
								case 'itemLabel':
									props.labelFontColor=xmlNode.getAttribute("color")
									props.labelFontName=xmlNode.getElementsByTagName("font")[0].getAttribute("fontName")
									props.labelFontSize=xmlNode.getElementsByTagName("font")[0].getAttribute("size")
									break;
								default:
									break;
							}
						};
						if(xmlNode.hasChildNodes()) {
							for(let i = 0, len = xmlNode.children.length;i < len;i++) {
								traversalNode3(xmlNode.children[i]);
							}
						}
					}else{
                		if(tagName=="barPlot"){
							props.isShowLabels=xmlNode.getAttribute("isShowLabels")
						}else{
							props.isShowLines=xmlNode.getAttribute("isShowLines")
							props.isShowShapes=xmlNode.getAttribute("isShowShapes")
						}

						const traversalNode5 = (xmlNode) => {
							//console.log(xmlNode);
							const { tagName } = xmlNode;
							//console.log(tagName);

							switch (tagName) {
								case 'plot':
									props.orientation=xmlNode.getAttribute("orientation");
									break;
								case 'itemLabel':
									props.labelFontColor=xmlNode.getAttribute("color")
									props.labelFontName=xmlNode.getElementsByTagName("font")[0].getAttribute("fontName")
									props.labelFontSize=xmlNode.getElementsByTagName("font")[0].getAttribute("size")
									break;
								case 'categoryAxisLabelExpression':
									props.categoryAxisLabelExpression=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');

									break;
								case 'categoryAxisFormat':
									props.categoryVerticalTickLabels=xmlNode.getElementsByTagName("axisFormat")[0].getAttribute("verticalTickLabels")
									if(props.categoryVerticalTickLabels=="true"){
										props.categoryVerticalTickLabels=true;
									}else if(props.categoryVerticalTickLabels=="false"){
										props.categoryVerticalTickLabels=false;
									}
									break;
								case 'valueAxisLabelExpression':
									props.valueAxisLabelExpression=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');

									break;
								case 'valueAxisFormat':
									props.valueVerticalTickLabels=xmlNode.getElementsByTagName("axisFormat")[0].getAttribute("verticalTickLabels")
									if(props.valueVerticalTickLabels=="true"){
										props.valueVerticalTickLabels=true;
									}else if(props.valueVerticalTickLabels=="false"){
										props.valueVerticalTickLabels=false;
									}
									break;
								case 'rangeAxisMinValueExpression':
									props.rangeAxisMinValueExpression=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');


									break;
								case 'rangeAxisMaxValueExpression':
									props.rangeAxisMaxValueExpression=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');


									break;
								default:
									break;
							}
						};
						if(xmlNode.hasChildNodes()) {
							for(let i = 0, len = xmlNode.children.length;i < len;i++) {
								traversalNode5(xmlNode.children[i]);
							}
						}
					}

                    break;
				case 'barPlot':


					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes()) {
			for(let i = 0, len = xmlNode.children.length;i < len;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}
		//console.log(props)
		this.setProps(props);

		return props;
	}
	

}

Chart.DEF_TEXT = 'chart';

export default Chart;