//日期字符串转时间戳
export const dateToTime = (date) => {
  let time = new Date(date).getTime();
  return time;
}
//特殊字符校验
export const validateSpecial = (rule, value, callback) => {
  const regText = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/g;
  if (!regText.test(value)) {
    return callback(new Error("不能输入特殊字符"));
  } else {
    callback();
  }
};
//名称统一校验
export const nameCheck = (rule, value, callback) => {
  const regText = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/g;
  if(value.length>40){
    return callback(new Error("名称不能超过40个字"));
  }
  else if (!regText.test(value)) {
    return callback(new Error("名称不能输入特殊字符"));
  } else {
    callback();
  }
};
//描述统一校验
export const descCheck = (rule, value, callback) => {
  if(value, value.length>150){
    return callback(new Error("描述字段长度不能超过150个字符"));
  } else {
    callback();
  }
};
//描述统一校验
export const spaceCheck = (rule, value, callback) => {
  if(value.trim() == ""){
    return callback(new Error("不能只输入空格"));
  } else {
    callback();
  }
};
//时间戳转日期字符串
export const TimeToDate = (time,formatString) => {
  formatString = formatString? formatString: "YYYY-MM-DD h:m:s";
  let now = new Date(time);
  let yy = now.getFullYear();      //年
  let mm = now.getMonth() + 1;     //月
  let dd = now.getDate();          //日
  let hh = now.getHours();         //时
  let ii = now.getMinutes();       //分
  let ss = now.getSeconds();       //秒
  // let date = yy + "-";
  // if(mm < 10) date += "0";
  // date += mm + "-";
  // if(dd < 10) date += "0";
  // date += dd + " ";
  // if(hh < 10) date += "0";
  // date += hh + ":";
  // if (ii < 10) date += "0"; 
  // date += ii + ":";
  // if (ss < 10) date += "0"; 
  // date += ss;
  // return date;

  let date;
  switch(formatString) {
      case "YYYY-MM-DD h:m:s":
          date = yy + "-";
          if(mm < 10) date += "0";
          date += mm + "-";
          if(dd < 10) date += "0";
          date += dd + " ";
          if(hh < 10) date += "0";
          date += hh + ":";
          if (ii < 10) date += "0"; 
          date += ii + ":";
          if (ss < 10) date += "0"; 
          date += ss;

          break;
      case "YYYY-MM-DD":
          date = yy + "-";
          if(mm < 10) date += "0";
          date += mm + "-";
          if(dd < 10) date += "0";
          date += dd;

          break;
  }
  return date;

}

// 获取cookie
export const getCookie = (cname) =>{
  let name = cname + "=";
  let ca = document.cookie.split(';');
  for(let i=0; i<ca.length; i++) 
  {
    let c = ca[i].trim();
    if (c.indexOf(name)==0) return c.substring(name.length,c.length).toLocaleLowerCase()
  }
  return "zh";
}

// 设置cookie
export const setCookie = (cname,cvalue,exdays) =>{
  const d = new Date();
  d.setTime(d.getTime()+(exdays*24*60*60*1000));
  const expires = "expires="+d.toGMTString();
  document.cookie = cname + "=" + cvalue + "; " + expires;
}

// 清除cookie
export const delCookie = (name) => {
  setCookie(name, ' ', -1);
}

// 判断是否显示id
export const checkHasId = (arr, id) => {
  let flag = true
  if(arr.length == 0){
    flag = true;
  }else{
    for (let i = 0; i < arr.length; i++) {
      if (arr[i].id == id) {
        flag = false;
        break;
      }
    }
  }
  if(flag){
    id = ''
  }
  return id
}

// 对象转数组
export const obj2Arr = (arr) => {
  let list = []
  for (let key in arr) {
    let obj = {}
    obj.id = key
    obj.name = arr[key]
    list.push(obj)
  }
  return list
}