class AuxiliaryLine {
	static instance = null;
	
	static getInstance() {
		if(!AuxiliaryLine.instance || !(AuxiliaryLine.instance instanceof AuxiliaryLine)) {
			AuxiliaryLine.instance = new AuxiliaryLine();
		}

		return AuxiliaryLine.instance;	
	}
	
	constructor() {
		this.points = null;
		this.color = AuxiliaryLine.DEF_COLOR;
	}
	
	paint(g) {
		g.save();
		g.setLineWidth(1);
		g.setColor(this.color);
		
		if(this.points) {
			if(this.points.abscissa) {
				g.drawLine(this.points.abscissa.beginPoint.x, this.points.abscissa.beginPoint.y, 
				this.points.abscissa.endPoint.x, this.points.abscissa.endPoint.y);
			}

			if(this.points.ordinate) {
				g.drawLine(this.points.ordinate.beginPoint.x, this.points.ordinate.beginPoint.y, 
				this.points.ordinate.endPoint.x, this.points.ordinate.endPoint.y);
			}	
		}
		
		g.restore();
	}
	
	getProp(prop) {
		return this[prop];
	}
	
	setProps(newProps) {
		Object.assign(this, newProps);
	}
}

AuxiliaryLine.DEF_COLOR = '#9AFF9A';

export default AuxiliaryLine;