import { Message } from 'element-ui';
// 引入 axios
import axios from 'axios';
const instance = axios.create({
    // timeout: 5000, // 请求的超时时间
    //设置默认请求头，使post请求发送的是formdata格式数据// axios的header默认的Content-Type好像是'application/json;charset=UTF-8',我的项目都是用json格式传输，如果需要更改的话，可以用这种方式修改
    // headers: {  
    //   "Content-Type": "application/x-www-form-urlencoded"
    // },
    withCredentials: true // 允许携带cookie
    //adminToken
    // headers: {
    //     "adminToken": window.adminToken
    // },

});
instance.interceptors.request.use(
  config => {
    config.headers['adminToken'] = localStorage.getItem('adminToken');
    return config
  },
  err => {
    return Promise.reject(err)
  }
);

//http response 拦截器
instance.interceptors.response.use(
  response => {
    console.log("axios.interceptors.response");
    // 请求成功后批量处理错误信息
    if(response.data.errcode && response.data.errcode !== 0 && response.data.errmsg)
      Message.warning(response.data.errmsg)
    return response
  },
  error => {
    //未登录
    if (error.response.status == 401) {
      window.location = "index.html#/login";
    }
    else {
      Message.error(error.msg)
      return Promise.reject(error)
    }
  }
);
export default instance