import i18n from "@/i18n";
export default {
  ganttData: [
    // 甘特视图映射字段
    {
      label: i18n.t("view.task_name"),
      value: "name",
    },
    {
      label: i18n.t("view.start_date"),
      value: "start",
    },
    {
      label: i18n.t("view.end_date"),
      value: "end",
    },
    {
      label: i18n.t("view.complete"),
      value: "complete",
    },
    {
      label: i18n.t("view.color"),
      value: "color",
    },
    {
      label: i18n.t("view.taskid"),
      value: "parent",
    },
    {
      label: i18n.t("view.dependent_task"),
      value: "dependency",
    },
    {
      label: i18n.t("view.title"),
      value: "caption",
    },
    {
      label: i18n.t("view.description"),
      value: "description",
    },
  ],
  treeData: [
    // 树形视图映射字段
    {
      label: i18n.t("view.parent_node"),
      value: "superior_Node",
    },
    {
      label: i18n.t("view.current_node_num"),
      value: "current_Node",
    },
    {
      label: i18n.t("view.current_node_name"),
      value: "name_Node",
    },
  ],
  mapData: [ // 地图视图映射字段
    {
      label: i18n.t('view.map_title'),
      value: "titlecolumn",
    },
    {
      label: i18n.t('view.map_detailed_address'),
      value: "addresscolumn",
    },
    {
      label: i18n.t('view.map_content'),
      value: "detailcolumn",
    },
  ],
  calendarData: [ // 日历视图映射字段
    {
      label: i18n.t('view.calendar_view'),
      value: "CldViewDateColum",
    },
  ],
  actTypeOptions: [ // 视图操作类型
    {
      label: "创建",
      value: "2",
    },
    {
      label: "删除",
      value: "3",
    },
    {
      label: "保存",
      value: "34",
    },
    {
      label: "清空所有数据",
      value: "18",
    },
    {
      label: "载入视图",
      value: "1",
    },
    {
      label: "批量提交",
      value: "20",
    },
    {
      label: "批量签章",
      value: "29",
    },
    {
      label: "导出Excel",
      value: "16",
    },
    {
      label: "导入Excel",
      value: "27",
    },
    {
      label: "文件下载",
      value: "26",
    },
    {
      label: "网页打印",
      value: "36",
    },
    {
      label: "跳转",
      value: "43",
    },
  ],
  btnActionTypeOptions: [ // 表单操作类型
    {
      label: i18n.t('form.custom'),
      value: "13",
    },
    {
      label: i18n.t('form.save'),
      value: "34",
    },
    {
      label: i18n.t('form.save_and_start_flow'),
      value: "4",
    },
    {
      label: i18n.t('form.save_back'),
      value: "11",
    },
    {
      label: i18n.t('form.save_new'),
      value: "42",
    },
    {
      label: i18n.t('form.save_draft'),
      value: "19",
    },
    {
      label: i18n.t('form.save_copy'),
      value: "21",
    },
    {
      label: i18n.t('form.flow_processing'),
      value: "5",
    },
    {
      label: i18n.t('form.start_workflow'),
      value: "33",
    },
    {
      label: i18n.t('form.back'),
      value: "10",
    },
    {
      label: i18n.t('form.close_window'),
      value: "8",
    },
    {
      label: i18n.t('form.web_print'),
      value: "14",
    },
    // {
    //   label: "网页打印(包含流程历史)",
    //   value: "15",
    // },
    {
      label: i18n.t('form.custom_print'),
      value: "30",
    },
    {
      label: i18n.t('form.pdf_export'),
      value: "25",
    },
    {
      label: i18n.t('form.file_download'),
      value: "26",
    },
    {
      label: i18n.t('form.electronic_signature'),
      value: "28",
    },
    {
      label: i18n.t('form.share_with_email_or_sms'),
      value: "37",
    },
    {
      label: i18n.t('form.jump'),
      value: "43",
    },
    {
      label: i18n.t('form.signature'),
      value: "46",
    },
  ],
};
