import MasterSheet from './MasterSheet'
import DetailSheet from './DetailSheet'
import Relation from './Relation'
import Node from './Node'
import Element from './Element'

import Graphics from '../utility/Graphics'
import Point from '../utility/Point';
import Resources from '../utility/Resources';
import Sequence from '../utility/Sequence';
import FlowType from '../utility/FlowType';
import Column from './Column';
import rollBack from './rollBack';


class ExcelMappingDiagram {
    constructor(canvas) {
        this.canvas = canvas;
        this._elems = [];
		this.g = new Graphics(canvas.getContext('2d'));
		

		this._statues = ExcelMappingDiagram.ACTION_NORMAL;
		this._currToEdit = null;
		
		this._tmpimg = "";
		// this._drag = false;
		this._selected = null;// **
		this.flowstatus = FlowType.FLOWSTATUS_OPEN_NOSTART;
		this.flowpath = "";
		this.deleteMSG = null;
		this.width = 2048;
		this.height = 1536;
		// this._applicationid = null;
		// this._sessionid = null;
		this._changed = false;
		// this._zoomrate = 1;
		this.win = null;
		// this.id = null;

		this.description = "";
		this.needRollback = "";
		this.haveTips=false;
		this.needRollback = "rollback";
        // var masterSheet1 = new MasterSheet(this);  
        // masterSheet1.name = 'masterSheet' ;     
        // this._elems.push (masterSheet1);
        // var detailSheet1 = new DetailSheet(this);
        // detailSheet1.name = 'detailSheet111'
        // this._elems.push (detailSheet1);
        // this._elems.push(new Relation(this));
	}
	
	setJSObject(win) {
		this.win = win;
	}

	get_statues() {
		return this._statues;
	}

	getLocationWithCanvas(canvas, x, y) {  
		var bbox = canvas.getBoundingClientRect();  
		return {  
			x: (x - bbox.left) * (canvas.width / bbox.width),   
			y: (y - bbox.top) * (canvas.height / bbox.height)  
		};  
	}  

	// 编辑时用到的接口
	getCurrToEdit() {
		return this._currToEdit;
	}

	setCurrToEdit(_currToEdit) {
		this._currToEdit = _currToEdit;
	}

	getChanged() {
		return this._changed;
	}

	editNode(grp) {
		this._selected = grp;
	}

	getWidth() {
		return this.width;
	}

	setWidth(width) {
		this.width = width;
	}

	getHeight() {
		return this.height;
	}

	setHeight(height) {
		this.height = height;
	}

	getDescription() {
		return this.description;
	}

	setDescription(description) {
		this.description = description;
	}

	getNeedRollback() {
		return this.needRollback;
	}

	setNeedRollback(needRollback) {
		this.needRollback = needRollback;
	}

	editRelation(rlt) {
		this._selected = rlt;
	}

	isCurrentSelected(em) {
		if (em != null && this._selected != null && Object.is(em, this._selected)) {
			return true;
		} else {
			return false;
		}
	}

	isCurrentToEdit(em) {
		if (em != null && this._currToEdit != null && Object.is(em, this._currToEdit)) {
			return true;
		} else {
			return false;
		}
	}

	isContain(all, beforeNode) {
		if (all != null) {
			for(let i = 0; i < all.length; i++){
				let item = all[i];
				if (item instanceof Node) {
					let n = item;
					if (n.id == beforeNode.id) {
						return true;
					}
				}
			}
		}
		return false;
	}

	addMasterSheet(name, formName, description) {
		this.changeStatues(ExcelMappingDiagram.ACTION_ADD_NODE);
		let node = new MasterSheet(this);
		node.name = name;
		node.formName = formName;
		node.description = description;
		node.x = 50;
		node.y = 50;

		this.appendElement(node);
		this.paint();
		this.editNode(node);
	}

	addDetailSheet(name, formName, description) {
		this.changeStatues(ExcelMappingDiagram.ACTION_ADD_NODE);
		let node = new DetailSheet(this);
		node.name = name;
		node.formName = formName;
		node.description = description;
		node.x = 80;
		node.y = 80;

		this.appendElement(node);
		this.paint();
		this.editNode(node);
	}

	addColumn(name,fieldName,valueScript,validateRule,primaryKey,description) {
		this.changeStatues(ExcelMappingDiagram.ACTION_ADD_NODE);
		let node = new Column(this);
		node.name = name;
		node.fieldName = fieldName;
		node.valueScript = valueScript;
		node.validateRule = validateRule;
		node.primaryKey = primaryKey;
		node.description = description;
		node.x = 100;
		node.y = 100;
		this.appendElement(node);
		this.paint();
		this.editNode(node);

	}

	addRelation() {
		this.changeStatues(ExcelMappingDiagram.ACTION_ADD_RELATION);
		let rlt = new Relation(this);
		this.appendElement(rlt);
		this.editRelation(rlt);
	}

	delRelation(id) {
		this.delElement(id);
	}


	/**
	 * 改变鼠标状态
	 * 
	 * @param statues
	 * @roseuid 3E0A6E1A0258
	 */
	changeStatues(statues) {

		this._statues = statues;
		switch (this._statues) {
        case ExcelMappingDiagram.ACTION_NORMAL:
            this.canvas.style.cursor = "pointer";
			break;
        case ExcelMappingDiagram.ACTION_REMOVE:
            this.canvas.style.cursor = "pointer";
			break;
		case ExcelMappingDiagram.ACTION_ADD_ACTOR:
            this.canvas.style.cursor = "pointer";
			break;
		case ExcelMappingDiagram.ACTION_ADD_NODE:
            this.canvas.style.cursor = "pointer";
			break;
		case ExcelMappingDiagram.ACTION_BREAK_LINE: // add by gusd
            this.canvas.style.cursor = "pointer";
			break; // end

        default:
            this.canvas.style.cursor = "initial";
		}
	}

	delElement(id) {

		for (let e = _elems.elements(); e.hasMoreElements();) {
			let em = e.nextElement();
			if (em.id != null && em.id.equals(id)) {
				_elems.removeElement(em);
			}

		}
    }
	
	paintTo(og, fillBackground) {

		// 清除背景
		if (fillBackground) {

			og.setColor(Resources.COLOR.white);

			og.fillRect(0, 0, this.width, this.height);
			
			//画两个回退按钮及背景
			if(this.needRollback){
				og.setColor("#ebe7e7");
				og.fillRect(0, 0, this.width, 25);
				let needRoll = new rollBack(this.needRollback);
				needRoll.init(this.canvas)

			}

            // 画背景网格
            og.setColor(Resources.COLOR.lightGray);

			for (let i = 0; i < this.width / 50; i++) {
				og.drawLine(i * 50, 25, i * 50, this.height);
			}

			for (let i = 0; i < this.width / 5; i++) {
				og.drawLine(i * 5, 25, i * 5, 30);
			}

			for (let i = 0; i < this.width / 25; i++) {
				og.drawLine(i * 25, 25, i * 25, 35);
			}

			for (let i = 0; i < this.width / 50; i++) {
				og.drawLine(25, i * 50, this.width, i * 50);
			}

			for (let i = 0; i < this.width / 5; i++) {
				og.drawLine(0, i * 5+25, 5, i * 5+25);
			}

			for (let i = 0; i < this.width / 25; i++) {
				og.drawLine(0, i * 25, 10, i * 25);
			}

		} else {
            og.setColor(Resources.COLOR.lightGray);
			og.fillRect(0, 0, 2048, 1536);
			//og.fillRect(0, 0, width, height);
			// og.clearRect(0, 0, width, height);
		}
        
        // 画元素      
		this._elems.forEach(elem => {
            if(elem instanceof Element){
				elem.paint(this.g);
            }
        }) 
	}


    paint() {
		this.paintTo(this.g, true);        
	}

	update(g, fillWhiteColor) {
		if (fillWhiteColor) {
			g.setColor(Resources.COLOR.white);
			g.fillRect(0, 0, this.width, this.height);
		} else {
			// tg.clearRect(0, 0, this.size().width, this.size().height);
			g.clearRect(0, 0, this.width, this.height);
		}

		this._elems.forEach(elem => {
            if(elem instanceof Element){
				elem.paint(this.g);
            }
        }) 
	}
	
	repaint() {
		// console.log('repaint')
		this.paint();
	}

	toXML() {
		let rslt = "";
		try {
			let tagNames = [
				'flowstatus',
				'flowpath',
				'deleteMSG',
				'width',
				'height',
				'_applicationid',
				'_sessionid',
				'needRollback',
			];
			let cls = this;
			rslt = "<cn.myapps.runtime.dynaform.dts.excelimport.ExcelMappingDiagram>\n";
			for(let key in cls){
				if(tagNames.indexOf(key) >= 0){
					let clsValue = cls[key] == null ? "" : cls[key];
					rslt += "<" + key + ">" + clsValue + "</" + key + ">\n";
				}
			}
			let flds = this._elems;
			for(let i = 0; i < flds.length; i++){
				rslt += flds[i].toXML();
			}
			rslt += "</cn.myapps.runtime.dynaform.dts.excelimport.ExcelMappingDiagram>\n";
		} catch (e) {

		}

		return rslt;

	}

	check() {
		let flds = this._elems;
		let result = '';
		let primaryKeyCount = 0;

		for(let i = 0;i < flds.length;i++) {

			if(flds[i] instanceof Column) {
				if(flds[i].primaryKey) {
					primaryKeyCount++;
				}
			}

		}

		if(primaryKeyCount >= 2) {
			alert('主键只能存在一个！');
			return false;
		}

		return true;

	}
	
	removeElement(emn) {
		if (emn != null) {
			if (emn instanceof Node) {
				let v = this.getAllElements();
				for (let i = 0; i < v.length; i++) {
					let elem = v[i];
					if (elem instanceof Relation) {
						let r = elem;
						if ((r.startnodeid != null && r.startnodeid == emn.id)
								|| (r.endnodeid != null && r.endnodeid == emn.id)) {
							this._elems = this._removeElementFromArray(this._elems, r);
						}
					}
				}
				this._elems = this._removeElementFromArray(this._elems, emn);
			} else {
				this._elems = this._removeElementFromArray(this._elems, emn);
			}
		}
		this._currToEdit = null;	
	}

	_removeElementFromArray(array, element){

        for(let i = 0; i < array.length; i++){
			let em = array[i];
			if (em.id != null && em.id == element.id) {
				return [
					...array.slice(0, i),
					...array.slice(i + 1)
				]
			}
        }
	}

	/**
	 * @param id
	 * @roseuid 3E0A6E1B00AB
	 */
	removeElementById(id) {
		const elems = this._elems;
        for(let i = 0; i < elems.length; i++){
			let em = elems[i];
			if (em.id != null && em.id == id) {
				this._elems = [
					...this._elems.slice(0, i),
					...this._elems.slice(i + 1)
				]
			}
        }
	}

	/**
	 * @param x
	 * @param y
	 * @return cn.myapps.runtime.workflow.Element
	 * @roseuid 3E0A6E1B00C9
	 */
	chkSelectedElement(x, y) {
        const elems = this._elems;
		//console.log(this._currToEdit);
        for(let i = 0; i < elems.length; i++){
            if(elems[i] instanceof Element){
				if (elems[i].isSelected(x, y)) {
					return elems[i];
				}
            }
        }
        return null;
	}

	getFlowstatus() {
		return this.flowstatus;
	}

	/**
	 * 设置流程运转路径
	 * 
	 * @param
	 * @uml.property name="flowpath"
	 */
	setFlowpath(path) {
		if (this.flowpath == null || this.flowpath.trim().length <= 0) {
			this.flowpath = path;
		} else {
			this.flowpath = this.flowpath + ";" + path;
		}
	}

	/**
	 * 获取流程运转路径
	 * 
	 * @param
	 */
	getFlowpath() {
		let colls = [];
		if (flowpath != null && flowpath.trim().length > 0) {
			let path = this.flowpath.split(';');
			for (let i = 0; i < path.length; i++) {
				let t = path[i].split(',');
				colls.add(t);
			}
		}
		return colls;
	}


	/**
	 * @return java.util.Vector
	 * @roseuid 3E0A6E1B00E7
	 */
	getAllElements() {
		let vct = [];
		const elems = this._elems;
        for(let i = 0; i < elems.length; i++){
			vct.push(elems[i]);
			
			if (elems[i]._subelems != null) {
				const _subelems = elems[i]._subelems
				for (let j = 0; j < _subelems.length; j++) {
					vct.push(_subelems[j]);
				}
			}
        }
        return vct;
	}

	getElementByID(id) {

		if (id == null || id.trim().length == 0) {
			return null;
		}
		
		const elems = this._elems;
        for(let i = 0; i < elems.length; i++){
			let em = elems[i]; 
			if (em && em.id != null && em.id == id) {
				return em;
			}

			//if (em && em.getSubelems() != null) {
			//	for(let j = 0; j < em.getSubelems().length; j++){
			//		let subem = em.getSubelems()[j];
			//		if (subem.id != null && subem.id == id) {
			//			return subem;
			//		}
			//	}
			//}
        }
        return null;
	}

	jbInit() {

        this.canvas.onmousemove = (e) => {
            this.mouseMove(e);
        };
        
        this.canvas.onclick = (e) => {
            this.mouseClick(e);
        };
        this.canvas.onmousedown = (e) => {
            this.mouseDown(e);
        };
        this.canvas.onmouseup = (e) => {
            this.mouseUp(e);
        };
        this.canvas.onmouseover = (e) => {

            //this_mouseEntered(e);
        }; 
	}


	/**
	 * @param e
	 * @roseuid 3E0A6E1B0123
	 */
	mouseClick(e) {
		const {x, y} = this.getLocationWithCanvas(this.canvas ,e.clientX, e.clientY);	
		let em = this.chkSelectedElement(x, y);
		//console.log(this._currToEdit);
		if (em != null) {
				console.log("选中em ",em);
		}else{
			this._currToEdit=null;
		}

		// yx判断不是中文才重新执行
		setTimeout(() => {
			if(getCookie('designerLanguage') != 'zh'){
				// 重新渲染多语言
				jQuery(document).ready(function(){
					let lang = getCookie('designerLanguage')
					// clearTimeout(timer)
					jQuery.i18n.properties({//加载资浏览器语言对应的资源文件
							name: "strings", //资源文件名称
							path: 'i18n/', //资源文件路径
							language: lang,
							cache: false,
							mode: 'map', //用Map的方式使用资源文件中的值
							callback: function () {//加载成功后设置显示内容
									for (let i in $.i18n.map) {
											$('[data-lang="' + i + '"]').text($.i18n.map[i]);
									}
									// document.title = $.i18n.map['title'];
							}
					});
				})
			}
		}, 0)
	}

	mouseDown(e) {
		const {x, y} = this.getLocationWithCanvas(this.canvas ,e.clientX, e.clientY);
		
		if(y<25){
			if(x<=270&&x>=25){
				this.needRollback="rollback";
				console.log(this.needRollback)
			}else if(x>=300&&x<=600){
				this.needRollback="notRollback";
				console.log(this.needRollback)
			}
		}
		
		let isChangeCursor = false;

		let em = this.chkSelectedElement(x, y);
		if (em != null) {
			if (em instanceof Node) {// 设置抓取点
				em._handlePoint.x = x - em.x;
				em._handlePoint.y = y - em.y;
			}
						
			this._changed = true;
			if (this._statues == ExcelMappingDiagram.ACTION_REMOVE) {
				// deleteMSG = null;
				if (this.deleteMSG == "null" || this.deleteMSG == null || this.deleteMSG == "") {
					this.removeElement(em);
				}else{
					alert(this.deleteMSG)
				}
			} else if (this._statues == ExcelMappingDiagram.ACTION_BREAK_LINE) { // add by gusd

				if (em instanceof Relation) {
					this._selected = em;
					let relation = this._selected;
					relation.setBreakpoint(new Point(x, y));
					isChangeCursor = true;
				}

			} // add by gusd

			else {
				if (this._selected instanceof Relation && em instanceof Node) {
					let r = this._selected;
					if (r.getStartnode() == null && em != null) {
						r.setStartnode(em);
						let node = em;
						let point = new Point(node.x, node.y);
						r.addVector(point);
					}
				} else if (em instanceof Relation) {
					this.changeStatues(ExcelMappingDiagram.ACTION_BREAK_LINE);
					this._selected = em;
					let relation = this._selected;
					relation.setChangevector(-1);
					relation.setBreakpoint(new Point(x, y));
					relation.setCurrentselect(true);
					isChangeCursor = true;

				} else {
					this._selected = em;
					this._selected.moveTo(x, y);
				}
			}
			this.repaint();
		} else {// em == null
			if ((this._statues == ExcelMappingDiagram.ACTION_ADD_RELATION) && (this._selected instanceof Relation)) {
				let r = this._selected;
				if (r.getStartnode() == null) {
					this.removeElement(r);
					r = null;
					this._selected = null;
				}
			} 
			this.repaint();
		}
		if (!isChangeCursor) { // isChangeCursor为true时，用户准备拖拉流程线，不释放鼠标指针的拖拉样式
			this.changeStatues(ExcelMappingDiagram.ACTION_NORMAL);
			isChangeCursor = false;
		}

	}

	/**
	 * @param e
	 * @roseuid 3E0A6E1B0155
	 */
	mouseUp(e) {
		const {x, y} = this.getLocationWithCanvas(this.canvas ,e.clientX, e.clientY);

		let em = this.chkSelectedElement(x, y);

		if (this._selected != null && this._selected instanceof Relation && (em == null || em instanceof Node)) {
			let r = this._selected;
			r.setCurrentselect(false);
			if (r.getEndnode() == null) {
				if (em != null) {
					this._changed = true;
					r.setEndnode(em);
					let node = em;

					let point = new Point(node.x, node.y);
					r.addVector(point);
				}
				if (em == null ){//|| (false && r.getStartnode().id.equals(r.getEndnode().id))) {
					this._elems = this._removeElementFromArray(this._elems, r)
				}
			} else {
				// 忽略掉10个像素差异
				let nx = Math.round((x + 10) / 20) * 20;
				let ny = Math.round((y + 10) / 20) * 20;

				let pos = r.getChangevector();
				r.setCurrentselect(false);
				if (pos == -1) { // 原先按下的点不是原有折点
					let bool = r.checkDistance(new Point(nx, ny));
					if (!bool) { // 检查鼠标释放的点拖拉的距离是否小于一个常量，如果是，则当作没有拖拉
						r.addVector(new Point(nx, ny)); // 如果鼠标释放的点拖拉的距离大于一个常量，则当作一个新的折点
					}
				} else { // 原先按下的点为原有折点，鼠标释放后要改变原有折点的坐标
					r.changeVector(new Point(nx, ny));
					r.setChangevector(-1);
				}

			}

		}
		// 设置当前选中
		if (this._selected != null && em != null && Object.is(this._selected, em)) {
			this._currToEdit = em;

			if (em instanceof Node) {
				let nd = em;

				let p = new Point(nd.x + nd._headRect.width / 2, nd.y + nd._headRect.height / 2);

				// 忽略掉10个像素差异
				let nx = p.x;
				let ny = p.y;

				// nx = Math.round((nx + 10) / 20) * 20;
				// ny = Math.round((ny + 10) / 20) * 20;

				em.x = nx - nd._headRect.width / 2;
				em.y = ny - nd._headRect.height / 2;
			}
		}

		this.changeStatues(ExcelMappingDiagram.ACTION_NORMAL);
		this._selected = null;

		this.repaint();
	}

	/**
	 * @param e
	 * @roseuid 3E0A6E1B0169
	 */
	mouseMove(e) {
		const {x, y} = this.getLocationWithCanvas(this.canvas ,e.clientX, e.clientY);
        if(e.buttons <= 0){
			if ((this._statues == ExcelMappingDiagram.ACTION_ADD_NODE)
				|| (this._statues == ExcelMappingDiagram.ACTION_ADD_ACTOR)) {
				// this.mouseDrag(e);
			} else if (this._statues == ExcelMappingDiagram.ACTION_BREAK_LINE) {
            } else {
                let tg = this.g;
                tg.setColor(Resources.COLOR.black);
				let em = this.chkSelectedElement(x, y);
                if ((em != null) && !(em instanceof Relation)) {
                    this.changeStatues(this._statues);
                    // if(this._statues == ACTION_REMOVE){
    
                    // }
                    let nd = em;

                    if (em.isSelected(x, y)&&!this.haveTips) {
                    	this.haveTips=true;
                        nd.showTips(tg); // 显示注释
                    }
                } else {
					this.haveTips=false;
                    this.repaint();
                }
				
            }
		}
		else{
			// const em = this.chkSelectedElement(e.x, e.y);
            // if ((em != null) && !(em instanceof Relation)) {
                // if (em.isSelected(e.x, e.y)) {
                    this.mouseDrag(e);
                // }
            // }
        }
		
	}

	/**
	 * @param e
	 * @roseuid 3E0A6E1B0187
	 */
    mouseDrag(e) {
		const {x, y} = this.getLocationWithCanvas(this.canvas ,e.clientX, e.clientY);
		if (this._selected != null && this._statues != ExcelMappingDiagram.ACTION_BREAK_LINE && this._selected instanceof Relation) { // 从一个结点到另一个结点画流程的拖拉过程中
			if (this._selected.getEndnode() == null) {
				this._selected.moveTo(x, y);
				this.repaint();
			}
		} else if (this._selected != null && this._statues != ExcelMappingDiagram.ACTION_BREAK_LINE) {
			this._selected.moveTo(x, y);
			this.repaint();
		} else if (this._selected != null && this._selected instanceof Relation && this._statues == ExcelMappingDiagram.ACTION_BREAK_LINE) { // 拖拉流程线产生折点的过程
			const pos = this._selected.getChangevector(); // 检查拖拉点是否原有折点
			this._selected.setCurrentselect(true);
			if (pos == -1) { // 拖拉点不是原有折点，把鼠标移动点作为临时的_movepoint
				this._selected.setMovepoint({x:x, y:y});
			} else { // 拖拉点是原有折点,鼠标移动点当作原有折点的新位置
				this._selected.changeVector({x:x, y:y});
			}
			this.repaint();
		} // end
	}

	// this_componentResized(e) {
	// 	this._tmpimg = this.createImage(this.getSize().width, this.getSize().height);
	// }
	
	appendElement(e) {
		this._elems.push(e);
	}

	getMasterSheet() {
		let iter = this._elems;
		for(let i=0;i<iter.length;i++) {
			if(iter[i] instanceof MasterSheet) {
				return iter[i];
			}
		}
		return null;
	}

	getDetailSheets() {
		let rtn = [];
		let iter = this._elems;
		for(let i=0;i<iter.length;i++) {
			if(iter[i] instanceof DetailSheet) {
				rtn.push(iter[i]);
			}
		}
		return rtn;
	}

	getLinkageKeys() {
		let rtn = [];
		let iter = this._elems;
		for(let i=0;i<iter.length;i++) {
			if(iter[i] instanceof Relation) {
				let lk = iter[i].getLinkageKey();
				if(lk!=null)
				rtn.push(iter[i]);
			}
		}
		return rtn;
	}


	getLinkageKeyByMasterKey(masterKeyColumn) {
		let linkageKeys = getLinkageKeys();
		for(let i=0;i<linkageKeys.length;i++) {
			let key = linkageKeys[i];
			let msk = key.getMasterSheetKeyColumn();
			if (msk.name != null && Object.is(msk.name,masterKeyColumn.name)) {
				return key;
			}
		}
		return null
	}

	getLinkageKeyByDetailKey(detailKeyColumn) {
		let linkageKeys = getLinkageKeys();
		for(let i=0;i<linkageKeys.length;i++) {
			let key = linkageKeys[i];
			let msk = key.getDetailSheetKeyColumn();
			if (msk.name != null && Object.is(msk.name,detailKeyColumn.name)) {
				return key;
			}
		}
		return null
	}

	


	
}



// ExcelMappingDiagram.serialVersionUID = 7116266842685042424;
ExcelMappingDiagram.ACTION_NORMAL = 0x00000000;
ExcelMappingDiagram.ACTION_REMOVE = 0x00000001;
ExcelMappingDiagram.ACTION_ADD_ACTOR = 0x00000010;
ExcelMappingDiagram.ACTION_ADD_NODE = 0x00000100;
ExcelMappingDiagram.ACTION_ADD_RELATION = 0x00001000;
ExcelMappingDiagram.ACTION_EDIT_ACTOR = 0x10000010;
ExcelMappingDiagram.ACTION_EDIT_NODE = 0x10000100;
ExcelMappingDiagram.ACTION_EDIT_RELATION = 0x10001000;
ExcelMappingDiagram.ACTION_EDIT_GROUP = 0x10010000;
ExcelMappingDiagram.ACTION_BREAK_LINE = 0x00100000;
ExcelMappingDiagram.PROCESSOR_TYPE_ACTOR = 1;
ExcelMappingDiagram.PROCESSOR_TYPE_PERSON = 2;
ExcelMappingDiagram.PROCESSOR_TYPE_GROUP = 3;
ExcelMappingDiagram.PROCESSOR_TYPE_TIMER = 4;
ExcelMappingDiagram.IMPORT_ROLLBACK_ALL = "rollback";
ExcelMappingDiagram.IMPORT_NOT_ROLLBACK_ALL = "notRollback";
ExcelMappingDiagram.ACTION_ADD_ACTOR = 0x00000010;
ExcelMappingDiagram.ACTION_ADD_ACTOR = 0x00000010;


export default ExcelMappingDiagram