import TextElement from './TextElement';
import {Sequence, Archor} from '../../utility';

class PageNumber extends TextElement {
	constructor() {
		super();
		this.text = PageNumber.DEF_EXPRESSION;
		this.isBlankWhenNull = false;
		this.isStretchWithOverflow = false;
		this.pattern = '';
		this.patternExpression = '';
		this.evaluationTime = PageNumber.DEF_EVALUATION_TIME;
		this.belong = '';
		this.isOpenArchor = false;
		// this.typeOption={
		// 	"Date":`<option>29/07/2019</option><option>07/2019</option>`,
		// 	"Time":`<option>11.43</option><option>11.43.56</option>`,
		// }
		this.key="页码";
	}
	
	getClassName() {
		return 'PageNumber';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		node.icon = 'glyphicon glyphicon-glass';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		let that=this;
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		if(this.paragraph.lineSpacing=="1.5"){
			this.paragraph.lineSpacingSize=1.5;
		}else if(this.paragraph.lineSpacing=="Single"){
			this.paragraph.lineSpacingSize=1;
		}else if(this.paragraph.lineSpacing=="Double"){
			this.paragraph.lineSpacingSize=2;
		}
		g.save();	
		g.setColor(this.backcolor);
		g.setLineWidth(0.5);

		if(this.mode == 'Opaque') {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.fillRect(this.x+this.lineWidth*(5/2), this.y+this.lineWidth*(5/2), this.width-this.lineWidth*5, this.height-this.lineWidth*5);
			}else{
				g.fillRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth);
			}

			//g.fillRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth);

		} else {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			g.drawRect(this.x,this.y,this.width,this.height)
			//g.stroke();
			//g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				//g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.drawRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4,this.radius);
				//g.stroke();
			}
			//g.strokeRect(this.x+this.lineWidth, this.y+this.lineWidth, this.width-this.lineWidth*2, this.height-this.lineWidth*2);
		}
		g.setLineStyle();
		g.restore();
		
		let tx = 0;
		let ty = 0;
		let font = '';
			
		if(this.font) {
			let italic = this.font.isItalic ? 'italic ' : '';
			let bold = this.font.isBold ? 'bold ' : '';
			font += italic;
			font += bold;
			font += this.font.size + 'px ';
			font += this.font.fontName + ' ';
		}
		
		g.setColor(this.forecolor);
		g.setFont(font);
		
		let textLen = g.getTextWidth(this.text);
		let multiple = Math.ceil(textLen / this.width);//文字真的行数
		let realMultiple = parseInt(this.height / (parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2));//此时的高度可以放多少行
		if(multiple<realMultiple){
			realMultiple=multiple;
		}

		let spare=0;
		if(this.textAlignment == 'Left') {
			g.textAlign('left');
			tx = this.x;
		} else if(this.textAlignment == 'Center') {
			g.textAlign('center');
			tx = (this.x + this.width) / 2 + this.x / 2;
		} else {
			g.textAlign('right');
			tx = this.x + this.width;	
		}
			
		if(this.verticalAlignment == 'Top') {
			g.textBaseLine('top');
			ty = this.y;
		} else if(this.verticalAlignment == 'Bottom') {
			g.textBaseLine('bottom');

			if(textLen > this.width) {
				ty = this.y + this.height - (parseInt(this.font.size)+(this.paragraph.lineSpacingSize*parseInt(this.font.size))/2) * (realMultiple - 1);
			} else {
				ty = this.y + this.height;
			}
		} else {
			g.textBaseLine('middle');

			if(textLen > this.width) {
				
				if(((parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*multiple)>this.height){
					//如果当前内容的总高度大于组件高度，所以只能显示当前组件高度可以显示的文字，这时还得计算显示完可以显示的内容之后还剩下的高度要均分到顶部和底部
					spare=(this.height-(parseInt(this.font.size)+this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*realMultiple)/2;
					ty = this.y + (this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)/2 + parseInt(this.font.size)/2 + spare
				}else{
					ty = this.y + (this.paragraph.lineSpacingSize * parseInt(this.font.size)/2)/2 + parseInt(this.font.size)/2 + (this.height - (parseInt(this.font.size) + this.paragraph.lineSpacingSize*parseInt(this.font.size)/2)*multiple)/2

				}
			} else {
				ty = (this.y + this.height) / 2 + this.y / 2;
			}
		}

		g.drawTextWithRow(this.text, tx, ty, this.width,this.height, parseInt(this.font.size),this.paragraph.lineSpacingSize,this.paragraph.firstLineIndent,this.paragraph.leftIndent,this.paragraph.rightIndent,spare);
		if(this.error){
			let img=new Image();
			img.src=this.errorImgSrc;
			img.onload=function(){
				g.drawImage(img,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
	}
	
	toXML() {
		this.pattern=this.type;
		let str = '<textField ';
		// str += `isBlankWhenNull = "${this.isBlankWhenNull}" `;
		// str += `isStretchWithOverflow = "${this.isStretchWithOverflow}" `;
		//


		
		if(this.evaluationTime != PageNumber.DEF_EVALUATION_TIME) {
			str += `evaluationTime = "${this.evaluationTime}"`;
		}
		
		str +=`>\n`;
		str += super.toXML2();
		str +="<box>\n"
		str +="<pen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<topPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<leftPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<bottomPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="<rightPen lineWidth=\""+this.lineWidth+"\" lineColor=\""+this.lineColor+"\" lineStyle=\""+this.lineStyle+"\"/>\n"
		str +="</box>\n"
		str += super.toXML3();
		str += `<textFieldExpression><![CDATA[${this.text}]]></textFieldExpression>\n`;
		
		// if(this.patternExpression != '') {
		// 	str+= `<patternExpression><![CDATA[${this.patternExpression}]]></patternExpression>`;
		// }
			
		str += '</textField>\n';
		
		return str;
	}
	
	parseXML(xmlNode) {
		//if(xmlNode.getElementsByTagName("textFieldExpression")[0].innerHTML.indexOf("Variable"))
		let props = {};

		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'reportElement':
					const reportElement = this.handleReportElement(xmlNode);
					Object.assign(props, reportElement);
					break;
				case 'textFieldExpression':
					props.text = this.replaceText(xmlNode.childNodes[0].nodeValue);
					console.log(props.text)
					break;
				case 'textElement':
					const textElement = this.handleTextElement(xmlNode);
					Object.assign(props, textElement);
					break;
				case 'patternExpression':
					props.patternExpression = this.replaceText(xmlNode.childNodes[0].nodeValue);
					break;
				case 'box':
					props.lineWidth=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineWidth")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineWidth"):0;
					props.lineColor=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineColor")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineColor"):"#000000";
					props.lineStyle=xmlNode.getElementsByTagName("pen")[0].getAttribute("lineStyle")?xmlNode.getElementsByTagName("pen")[0].getAttribute("lineStyle"):"solid";
					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes() && xmlNode.tagName == 'textField') {
			props.isBlankWhenNull = xmlNode.getAttribute('isBlankWhenNull') === 'true';
			props.isStretchWithOverflow = xmlNode.getAttribute('isStretchWithOverflow') === 'true';
			props.pattern = xmlNode.getAttribute('pattern') ? xmlNode.getAttribute('pattern') : '';
			props.evaluationTime = xmlNode.getAttribute('evaluationTime') ? xmlNode.getAttribute('evaluationTime') : PageNumber.DEF_EVALUATION_TIME;

			for(let i = 0;i < xmlNode.children.length;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}

		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

PageNumber.DEF_EXPRESSION = '$V{PAGE_NUMBER}';
PageNumber.DEF_EVALUATION_TIME = 'Now';

export default PageNumber;