import ReportElement from './ReportElement';

class TextElement extends ReportElement {
	constructor() {
		super();
		this.textAlignment = TextElement.DEF_TEXTALIGNMENT,
		this.verticalAlignment = TextElement.DEF_VERTICALALIGNMENT,
		this.markup = TextElement.DEF_MARKUP,
		this.font = {
			fontName: TextElement.DEF_FONTNAME,
			size: TextElement.DEF_FONTSIZE,
			isItalic: false,
			isBold: false,
			//isUnderline: false,
			//isStrikeThrough: true,
			isPdfEmbedded: false,
			pdfFontName: TextElement.DEF_PDF_FONTNAME,
			pdfEncoding: TextElement.DEF_PDF_ENCODING
		},
		this.paragraph = {
			lineSpacing: TextElement.DEF_LINESPING,
			lineSpacingSize: 1.0,
			leftIndent: 0, //左端缩进
			rightIndent: 0, //右端缩进
			firstLineIndent:0,//首行缩进
			tabStopWidth: 40
		}
	}
	
	toXML() {
		if(this.paragraph.lineSpacing=="1.5"){
			this.paragraph.lineSpacing="1_1_2";
		}
		let str = '';
		
		str += super.toXML();
		str += '<textElement ';
		str += `textAlignment = "${this.textAlignment}" `;
		str += `verticalAlignment = "${this.verticalAlignment}" `;
		if(this.markup) {
			str += ` markup = "${this.markup}" `;	
		}
		str += '>\n';
		str += '<font ';
		
		for(let key in this.font) {
			str += `${key} = "${this.font[key]}" `;
		}
		
		str += '/>\n';
		str += '<paragraph ';
		
		for(let _key in this.paragraph) {
			if(!this.paragraph[_key]){
				this.paragraph[_key]=0;
			}
			if(_key == 'lineSpacing' && this.paragraph[_key] == TextElement.DEF_LINESPING) {
				continue;
			} else if(_key == 'lineSpacingSize' && this.paragraph["lineSpacing"] == 'Fixed') {

				str += `${_key} = "${this.paragraph[_key]}" `;
			}else if(_key == 'lineSpacingSize' && this.paragraph["lineSpacing"] != 'Fixed'){
				continue;
			}else{
				str += `${_key} = "${this.paragraph[_key]}" `;
			}


		}
		
		str += '/>\n';
		str += '</textElement>\n';
		
		return str;
	}
	//只拼接reportElement
	toXML2() {
		let str = '';
		str += super.toXML();
		return str;
	}
	//只拼接textElement
	toXML3() {
		if(this.paragraph.lineSpacing=="1.5"){
			this.paragraph.lineSpacing="1_1_2";
		}
		let str = '';
		str += '<textElement ';
		str += `textAlignment = "${this.textAlignment}" `;
		str += `verticalAlignment = "${this.verticalAlignment}" `;
		if(this.markup) {
			str += ` markup = "${this.markup}" `;
		}
		str += '>\n';
		str += '<font ';

		for(let key in this.font) {
			str += `${key} = "${this.font[key]}" `;
		}

		str += '/>\n';
		str += '<paragraph ';

		for(let _key in this.paragraph) {
			if(!this.paragraph[_key]){
				this.paragraph[_key]=0;
			}
			if(_key == 'lineSpacing' && this.paragraph[_key] == TextElement.DEF_LINESPING) {
				continue;
			} else if(_key == 'lineSpacingSize' && this.paragraph["lineSpacing"] == 'Fixed') {

				str += `${_key} = "${this.paragraph[_key]}" `;
			}else if(_key == 'lineSpacingSize' && this.paragraph["lineSpacing"] != 'Fixed'){
				continue;
			}else{
				str += `${_key} = "${this.paragraph[_key]}" `;
			}


		}

		str += '/>\n';
		str += '</textElement>\n';


		return str;
	}
	
	handleTextElement(xmlNode) {
		let textElement = {};
		
		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'font':
					textElement.font = {};
					textElement.font.fontName = xmlNode.getAttribute('fontName') ? xmlNode.getAttribute('fontName') : TextElement.DEF_FONTNAME;
					textElement.font.size = xmlNode.getAttribute('size') ? xmlNode.getAttribute('size') : TextElement.DEF_FONTSIZE;
					textElement.font.isItalic = xmlNode.getAttribute('isItalic') === 'true';
					textElement.font.isBold = xmlNode.getAttribute('isBold') === 'true';
					textElement.font.isUnderline = xmlNode.getAttribute('isUnderline') === 'true';
					textElement.font.isStrikeThrough = xmlNode.getAttribute('isStrikeThrough') === 'true';
					textElement.font.isPdfEmbedded = xmlNode.getAttribute('isPdfEmbedded') === 'true';
					textElement.font.pdfFontName = xmlNode.getAttribute('pdfFontName') ? xmlNode.getAttribute('pdfFontName') : TextElement.DEF_PDF_FONTNAME;
					textElement.font.pdfEncoding = xmlNode.getAttribute('pdfEncoding') ? xmlNode.getAttribute('pdfEncoding') : TextElement.DEF_PDF_ENCODING;
					break;
				case 'paragraph':
					textElement.paragraph = {};
					textElement.paragraph.lineSpacing = xmlNode.getAttribute('lineSpacing') ? xmlNode.getAttribute('lineSpacing')=="1_1_2"? "1.5": xmlNode.getAttribute('lineSpacing'): TextElement.DEF_LINESPING;
                    textElement.paragraph.lineSpacingSize = parseInt(xmlNode.getAttribute('lineSpacingSize'));
                    textElement.paragraph.leftIndent = parseInt(xmlNode.getAttribute('leftIndent'));
					textElement.paragraph.firstLineIndent = parseInt(xmlNode.getAttribute('firstLineIndent'));
                    textElement.paragraph.rightIndent = parseInt(xmlNode.getAttribute('rightIndent'));
                    textElement.paragraph.tabStopWidth = parseInt(xmlNode.getAttribute('tabStopWidth'));
					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes() && xmlNode.tagName == 'textElement') {
			textElement.textAlignment = xmlNode.getAttribute('textAlignment') ? xmlNode.getAttribute('textAlignment') : TextElement.DEF_TEXTALIGNMENT;
			textElement.verticalAlignment = xmlNode.getAttribute('verticalAlignment') ? xmlNode.getAttribute('verticalAlignment') : TextElement.DEF_VERTICALALIGNMENT;
			textElement.markup = xmlNode.getAttribute('markup') ? xmlNode.getAttribute('markup') : TextElement.DEF_MARKUP;

			for(let i = 0;i < xmlNode.children.length;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}

		return textElement;
	}
}

TextElement.DEF_FONTNAME = 'SansSerif';
TextElement.DEF_LINESPING = 'Single';
TextElement.DEF_TEXTALIGNMENT = 'Center';
TextElement.DEF_VERTICALALIGNMENT = 'Middle';
TextElement.DEF_MARKUP = 'none';
TextElement.DEF_FONTSIZE = 12;
TextElement.DEF_PDF_FONTNAME = 'STSong-Light';
TextElement.DEF_PDF_ENCODING = 'UniGB-UCS2-H';

export default TextElement;
