import Element from "./Element"

class PaintElement extends Element {
    constructor(diagram){
        super(diagram);

        this.bgcolor = PaintElement.DEF_BGCOLOR; // 元素的背景色

        this.color = PaintElement.DEF_COLOR; // 元素使用的默认颜色

        this.font = PaintElement.DEF_FONT; // 元素使用的默认字体

        this.scale = 0;

        this.note = ""; // 备注
    }

    toXML(){
        var str = "";
        
		str+=super.toXML();
		str+="<scale>"+this.scale+"</scale>\n";
        str+="<note>"+this.replaceCharacter(this.note)+"</note>\n";
        
		return str;
	}
}

PaintElement.DEF_BGCOLOR = "white";
PaintElement.DEF_PASSCOLOR = "green";
PaintElement.DEF_COLOR = "black";
PaintElement.DEF_SELECTEDCOLOR = "pink";
PaintElement.DEF_CURREDITCOLOR = "orange";
PaintElement.DEF_PASSEDCOLOR = "green";
PaintElement.DEF_FONT = '12px -apple-system, "Microsoft YaHei", Arial, sans-serif';

export default PaintElement;