/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.SNCensorResult;
import com.bcxin.ars.webservice.dto.SNPerInfoDto;
import com.bcxin.ars.webservice.impl.BackGroupCensorServiceImpl;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="backGroupCensorService_610000")
public class SNBackGroupCensorServiceImpl
extends BackGroupCensorServiceImpl
implements BackGroupCensorService {
    private static Logger logger = LoggerFactory.getLogger(SNBackGroupCensorServiceImpl.class);
    @Autowired
    private BjRestLogDao bjRestLogDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    @Value(value="${ZAURL}")
    private String ZAURL;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String getPhoto(String idNumber, String name) {
        PersonBaseInfo populationInfo = this.getPopulationInfo(idNumber, true);
        return populationInfo.getPhoto();
    }

    @Override
    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        PersonBaseInfo person = new PersonBaseInfo();
        String code = "";
        boolean errorCount = false;
        String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + "S10-00000298";
        String count = this.redisUtil.get(key);
        if (StringUtil.isNotEmpty((String)count)) {
            Long total = Long.parseLong(count);
            Long max = 8000L;
            try {
                String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                max = Long.parseLong(configValue);
            }
            catch (Exception configValue) {
                // empty catch block
            }
            if (total >= max) {
                return person;
            }
        }
        String url = "http://92.1.31.17/datac/service/support/es/query";
        HashMap snPersonParams = Maps.newHashMap();
        snPersonParams.put("resId", "49");
        snPersonParams.put("sql", " (`GMSFHM`=?)");
        snPersonParams.put("accessId", "ba3146d4");
        snPersonParams.put("accessKey", "99565732e1654334859d52ae98b52c77");
        snPersonParams.put("reqId", "40");
        snPersonParams.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idnum));
        logger.error("snPersonRequestUrl:{}", (Object)url);
        logger.error("snPersonParams:{}", (Object)JSON.toJSONString((Object)snPersonParams));
        String responseContent = HttpUtil.post((String)url, (Map)snPersonParams);
        SNCensorResult snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
        logger.error("snCensorResult:{}", (Object)snCensorResult);
        JSONArray data = snCensorResult.getData();
        if (data.size() > 0) {
            JSONObject jsonObject = (JSONObject)data.get(0);
            SNPerInfoDto snPerInfo = (SNPerInfoDto)JSON.toJavaObject((JSON)jsonObject, SNPerInfoDto.class);
            logger.error("snPerInfo:{}", (Object)snPerInfo);
            if (snPerInfo != null) {
                if (needPhoto) {
                    String xp = snPerInfo.getZp();
                    String path = xp.substring(0, xp.lastIndexOf("/"));
                    String fileName = xp.substring(xp.lastIndexOf("/") + 1);
                    InputStream photoInputStream = FtpUtils.downloadFile((String)"92.1.31.25", (String)"xyyh", (String)"xyyh@123", (int)12100, (String)path, (String)fileName);
                    byte[] bytes = IoUtil.readBytes((InputStream)photoInputStream);
                    String base64Code = Base64.getEncoder().encodeToString(bytes);
                    person.setPhoto(base64Code);
                }
                person.setName(snPerInfo.getXm());
                person.setIdnum(snPerInfo.getGmsfhm());
                return person;
            }
        }
        return person;
    }

    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        Long businessid = dto.getBusinessid();
        String businesstype = dto.getBusinesstype();
        String idNumber = dto.getIdNumber();
        String name = dto.getRealName();
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(Boolean.valueOf(true));
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinesstype(businesstype);
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            if (needCZ) {
                boolean policeInterface = true;
                if (!"1".equals(dto.getAuthState())) {
                    SecurityPerson person;
                    if ("5".equals(businesstype) && (person = this.securityPersonDao.findByIdCardAndActive(idNumber)) != null && "1".equals(person.getIdentityAuthState())) {
                        policeInterface = false;
                    }
                } else {
                    policeInterface = false;
                }
                if (policeInterface) {
                    this.censorCZ(idNumber, name, cz_BackgroundApproval);
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                }
                list.add(cz_BackgroundApproval);
            }
            try {
                boolean snCensorResult;
                xd_BackgroundApproval.setLibraryType("2");
                boolean xdResult = snCensorResult = this.getSNCensorResult(idNumber, "2");
                if (xdResult) {
                    xd_BackgroundApproval.setApprovalreason("\u5438\u6bd2\u4eba\u5458");
                    xd_BackgroundApproval.setApprovalstate("004");
                    xd_BackgroundApproval.setRgapprovalstate("004");
                } else {
                    xd_BackgroundApproval.setApprovalreason("\u65e0\u5438\u6bd2\u8bb0\u5f55");
                    xd_BackgroundApproval.setApprovalstate("003");
                    xd_BackgroundApproval.setRgapprovalstate("003");
                }
                list.add(xd_BackgroundApproval);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            try {
                boolean ztCensorResult;
                dt_BackgroundApproval.setLibraryType("3");
                boolean ztResult = ztCensorResult = this.getSNCensorResult(idNumber, "3");
                if (ztResult) {
                    dt_BackgroundApproval.setApprovalreason("\u5728\u9003\u4eba\u5458");
                    dt_BackgroundApproval.setApprovalstate("004");
                    dt_BackgroundApproval.setRgapprovalstate("004");
                } else {
                    dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
                    dt_BackgroundApproval.setApprovalstate("003");
                    dt_BackgroundApproval.setRgapprovalstate("003");
                }
                list.add(dt_BackgroundApproval);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            try {
                boolean wfCensorResult;
                wf_BackgroundApproval.setLibraryType("4");
                boolean wfResult = wfCensorResult = this.getSNCensorResult(idNumber, "4");
                if (wfResult) {
                    wf_BackgroundApproval.setApprovalreason("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                    wf_BackgroundApproval.setApprovalstate("004");
                    wf_BackgroundApproval.setRgapprovalstate("004");
                } else {
                    wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
                    wf_BackgroundApproval.setApprovalstate("003");
                    wf_BackgroundApproval.setRgapprovalstate("003");
                }
                list.add(wf_BackgroundApproval);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u67e5\u8be2\u4eba\u53e3\u5e93\u5f02\u5e38\uff01");
        }
        return list;
    }

    private boolean send(String idNumber, String name, String requestID, String serviceID) {
        String code = "";
        boolean result = false;
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            for (int i = 0; i < 3; ++i) {
                String requestResult = this.send(idNumber, requestID, serviceID, new String[]{Constants.INFO_XM});
                BjRestLog log = new BjRestLog();
                log.setResttype(serviceID);
                log.setResponseContext(requestResult);
                log.setRequestContext(idNumber);
                log.setCreateTime(new Date());
                log.setActive(Boolean.valueOf(true));
                log.setUpdateTime(new Date());
                log.setUpdateBy("system");
                this.bjRestLogDao.save(log);
                if (requestResult != null && !requestResult.equals("")) {
                    try {
                        SAXReader reader = new SAXReader();
                        Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                        Element root = doc.getRootElement();
                        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                        if (valueElement != null) {
                            Element e;
                            List list = valueElement.elements();
                            if (list != null && list.size() > 0) {
                                e = (Element)list.get(0);
                                code = e.element("Data").getText();
                            }
                            if (list != null && list.size() > 2) {
                                e = (Element)list.get(2);
                                String resultname = e.element("Data").getText();
                                result = resultname != null && resultname.equals(name);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber + "---\u59d3\u540d\uff1a" + name);
                        logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38\uff1a" + result);
                        logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if ("000".equals(code)) break;
            }
            return result;
        }
        return true;
    }

    private String send(String idNumber, String requestID, String serviceID, String[] requiredItems) {
        String result = "";
        if (this.ZAFLAG != null && this.ZAFLAG.equals("1")) {
            String key = DateUtil.getCurrentDate((String)"yyyyMMdd") + "_" + serviceID;
            String count = this.redisUtil.get(key);
            if (StringUtil.isNotEmpty((String)count)) {
                Long total = Long.parseLong(count);
                Long max = 8000L;
                try {
                    String configValue = this.configService.getValueByKey("POLICE_INTERFACE_MAX");
                    max = Long.parseLong(configValue);
                }
                catch (Exception configValue) {
                    // empty catch block
                }
                if (total >= max) {
                    return result;
                }
            }
            this.redisUtil.getCount(key, 7L);
            RbspService service = new RbspService(requestID, serviceID);
            service.setUserCardId("asdfasd");
            service.setUserDept("0100");
            service.setUserName("ptjian");
            RbspCall call = service.createCall();
            call.setUrl(this.ZAURL);
            call.setMethod("Query");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("DataObjectCode", "M001");
            params.put("InfoCodeMode", "1");
            params.put("Condition", "SFZH = '" + idNumber.toUpperCase() + "'");
            params.put("RequiredItems", requiredItems);
            return call.invoke(params);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String requestResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RBSPMessage>    <Version/>    <ServiceID>S10-00000298</ServiceID>    <TimeStamp/>    <Validity/>    <Security>        <Signature Algorithm=\"\"/>        <CheckCode Algorithm=\"\"/>        <Encrypt/>    </Security>    <Method>        <Name>Query</Name>        <Items>            <Item>                <Value Type=\"arrayOfArrayOf_string\">                    <Row>                        <Data>000</Data>                        <Data/>                        <Data/>                    </Row>                    <Row>                        <Data>XM</Data>                        <Data>JGSSX</Data>                        <Data>ZZXZ</Data>                    </Row>                    <Row>                        <Data>\u5f20\u7acb</Data>                        <Data>612523</Data>                        <Data>\u68e3\u82b1\u9547\u4e07\u6e7e\u793e\u533a\u5c45\u59d4\u4f1a\u4e1c\u586c38\u53f7</Data>                    </Row>                </Value>            </Item>        </Items>    </Method></RBSPMessage>";
        SAXReader reader = new SAXReader();
        String pattern = "\\s{2,}";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(requestResult);
        requestResult = m.replaceAll("");
        Document doc = reader.read((InputStream)new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
        Element root = doc.getRootElement();
        Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
        if (valueElement != null) {
            Element e;
            List list = valueElement.elements();
            if (list != null && list.size() > 0) {
                e = (Element)list.get(0);
                System.out.println(e.element("Data").getText());
            }
            if (list != null && list.size() > 2) {
                e = (Element)list.get(2);
                System.out.println(((DefaultElement)e.content().get(0)).getText());
                System.out.println(((DefaultElement)e.content().get(1)).getText());
                System.out.println(((DefaultElement)e.content().get(2)).getText());
            }
        }
    }

    private boolean getSNCensorResult(String idNumber, String type) {
        String requestUrl = "http://92.1.31.17/datac/service/support/es/query";
        HashMap params = Maps.newHashMap();
        switch (type) {
            case "3": {
                params.put("resId", "38");
                params.put("sql", "(`ZJHM`=? and `ryzt_jyqk`=0)");
                break;
            }
            case "4": {
                params.put("resId", "62");
                params.put("sql", "(`ZJHM`=? and `ryjbxxbj` in ('0','1','5'))");
                break;
            }
            case "2": {
                params.put("resId", "57");
                params.put("sql", "(`gmsfhm`=? and `yxx`=1)");
                break;
            }
            default: {
                return false;
            }
        }
        params.put("accessId", "ba3146d4");
        params.put("accessKey", "99565732e1654334859d52ae98b52c77");
        params.put("reqId", "40");
        params.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
        logger.error("CensorRequestUrl:{}", (Object)requestUrl);
        logger.error("censorParams:{}", (Object)JSON.toJSONString((Object)params));
        String responseContent = HttpUtil.post((String)requestUrl, (Map)params);
        logger.error("\u9655\u897f\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2{}\u8fd4\u56de:{}", (Object)idNumber, (Object)responseContent);
        SNCensorResult snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
        return snCensorResult.getData().size() > 0;
    }
}

