/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.webservice.impl;

import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.ProblemPersonDaoAop;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProblemPerson;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.ClientUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BackGroupCensorServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(BackGroupCensorServiceImpl.class);
    @Autowired
    private PoliceService policeService;
    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private ProblemPersonDaoAop problemPersonDaoAop;
    @Autowired
    private SecurityCompanyPersonDao securityCompanyPersonDao;
    @Autowired
    private SecurityPersonDaoAop personDaoAop;
    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;
    @Autowired
    private ClientUtil clientUtil;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;

    public final void censorCZ(String idnum, String name, BackgroundApproval cz_BackgroundApproval) {
        try {
            cz_BackgroundApproval.setLibraryType("1");
            PersonBaseInfo personBaseInfo = this.getPopulationInfo(idnum, false);
            if (personBaseInfo != null) {
                if (StringUtil.isNotEmpty((String)personBaseInfo.getName()) && name.equals(personBaseInfo.getName())) {
                    cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
                    cz_BackgroundApproval.setApprovalstate("003");
                    cz_BackgroundApproval.setRgapprovalstate("003");
                } else {
                    cz_BackgroundApproval.setApprovalreason("\u59d3\u540d\u4fe1\u606f\u6709\u8bef");
                    cz_BackgroundApproval.setApprovalstate("004");
                    cz_BackgroundApproval.setRgapprovalstate("004");
                }
            } else {
                cz_BackgroundApproval.setApprovalreason("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                cz_BackgroundApproval.setApprovalstate("004");
                cz_BackgroundApproval.setRgapprovalstate("004");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u67e5\u8be2\u4eba\u53e3\u5e93\u5f02\u5e38\uff01");
        }
    }

    public PersonBaseInfo getPopulationInfo(String idnum, boolean needPhoto) {
        return null;
    }

    public final List<BackgroundApproval> censorNoInrawPro(BackgroundApprovalDto dto) {
        ArrayList<BackgroundApproval> list = new ArrayList<BackgroundApproval>();
        try {
            Long businessid = dto.getBusinessid();
            String businesstype = dto.getBusinesstype();
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(Boolean.valueOf(true));
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setBusinesstype(businesstype);
            cz_BackgroundApproval.setApprovalstate("003");
            cz_BackgroundApproval.setRgapprovalstate("003");
            BackgroundApproval xd_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval dt_BackgroundApproval = cz_BackgroundApproval.clone();
            BackgroundApproval wf_BackgroundApproval = cz_BackgroundApproval.clone();
            cz_BackgroundApproval.setApprovalreason("\u4e3b\u9879\u4fe1\u606f\u7b26\u5408");
            xd_BackgroundApproval.setApprovalreason("\u65e0\u5438\u6bd2\u8bb0\u5f55");
            dt_BackgroundApproval.setApprovalreason("\u65e0\u5728\u9003\u8bb0\u5f55");
            wf_BackgroundApproval.setApprovalreason("\u65e0\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55");
            cz_BackgroundApproval.setLibraryType("1");
            xd_BackgroundApproval.setLibraryType("2");
            dt_BackgroundApproval.setLibraryType("3");
            wf_BackgroundApproval.setLibraryType("4");
            list.add(cz_BackgroundApproval);
            list.add(xd_BackgroundApproval);
            list.add(dt_BackgroundApproval);
            list.add(wf_BackgroundApproval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public final List<BackgroundApproval> getCensorResult(BackgroundApprovalDto dto) {
        if (!ObjectUtils.equals((Object)"1", (Object)this.ZAFLAG)) {
            return this.censorNoInrawPro(dto);
        }
        return this.censorFromBase(dto, true);
    }

    public final String getCensorResult(List<BackgroundApproval> backgroundApprovals) {
        StringBuffer problemtype = new StringBuffer("");
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            String strResult = "";
            if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
            switch (backgroundApproval.getLibraryType()) {
                case "1": {
                    strResult = "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728";
                    break;
                }
                case "2": {
                    strResult = "\u5438\u6bd2\u4eba\u5458";
                    break;
                }
                case "3": {
                    strResult = "\u5728\u9003\u4eba\u5458";
                    break;
                }
                case "4": {
                    strResult = "\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55";
                    break;
                }
                case "99": {
                    strResult = backgroundApproval.getApprovalreason();
                    break;
                }
            }
            if (StringUtil.isEmpty((String)problemtype.toString())) {
                problemtype.append(strResult);
                continue;
            }
            problemtype.append("," + strResult);
        }
        return problemtype.toString();
    }

    public final void censorSaveProblemPerson(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        String idNumber = person.getIdNumber();
        String name = person.getRealName();
        ProblemPerson problemPerson = new ProblemPerson();
        ProblemPerson query = new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose("0");
        List list = this.problemPersonDao.findByPersonIdForUnDispose(query);
        if (list != null && list.size() > 0) {
            problemPerson = (ProblemPerson)list.get(0);
        } else {
            problemPerson.setCreateTime(new Date());
            problemPerson.setDispose("0");
        }
        problemPerson.setComparisonDate(new Date());
        if (person == null) {
            logger.error("\u5f02\u5e38\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
            return;
        }
        SecurityCompanyPerson securityCompanyPerson = this.securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(Boolean.valueOf(true));
        problemPerson.setUpdateBy("systemAuto");
        problemPerson.setIdnumber(idNumber);
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        if (securityCompanyPerson != null && securityCompanyPerson.getCompany() != null) {
            Police police;
            problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
            problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
            SecurityCompany company = securityCompanyPerson.getCompany();
            if (company.getComId().equals("591221865301671937") || StringUtil.isNotEmpty((String)company.getParentId()) && company.getParentId().equals("591221865301671937")) {
                police = this.policeService.findById(1000L);
                if (police != null) {
                    problemPerson.setOrgId(Long.valueOf(police.getId()));
                    problemPerson.setOrgName(police.getOrgname());
                    problemPerson.setAreaCode(police.getAreacode());
                }
            } else if (company.getId() == 610907743891451L || company.getId() == 610238522001631L) {
                police = this.policeService.findById(2000L);
                if (police != null) {
                    problemPerson.setOrgId(Long.valueOf(police.getId()));
                    problemPerson.setOrgName(police.getOrgname());
                    problemPerson.setAreaCode(police.getAreacode());
                }
            } else if (StringUtil.isNotEmpty((String)securityCompanyPerson.getCompany().getOrgId())) {
                problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
                problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
                problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
            }
        }
        problemPerson.setPhone(person.getPhone());
        problemPerson.setName(person.getRealName());
        problemPerson.setSex(person.getGender());
        problemPerson.setPersonid(person.getId());
        boolean result = true;
        boolean existsFlag = false;
        StringBuffer problemtype = new StringBuffer();
        if (backgroundApprovals != null && backgroundApprovals.size() > 0) {
            for (BackgroundApproval backgroundApproval : backgroundApprovals) {
                if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                problemtype.append(backgroundApproval.getApprovalreason()).append(",");
                result = false;
            }
        }
        problemPerson.setUpdateflag(Boolean.valueOf(true));
        query.setCompanyid(problemPerson.getCompanyid());
        List dbList = this.problemPersonDao.findByPersonIdForMax(query);
        if (!result) {
            String[] problemtypes;
            block1: for (String type : problemtypes = problemtype.toString().split(",")) {
                if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(type = type.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a")) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(type)) continue;
                for (ProblemPerson p : dbList) {
                    String[] dbProblemtypes;
                    for (String dbType : dbProblemtypes = p.getProblemtype().split(",")) {
                        if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(dbType) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(dbType) || !StringUtil.trim((String)(dbType = dbType.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a"))).equals(StringUtil.trim((String)type))) continue;
                        existsFlag = true;
                        break;
                    }
                    if (!existsFlag) continue;
                    continue block1;
                }
            }
            if (!existsFlag) {
                problemtype.deleteCharAt(problemtype.length() - 1);
                if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(problemtype.toString()) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(problemtype.toString())) {
                    problemPerson.setPersonType("1");
                } else if (problemtype.toString().indexOf("\u5728\u9003") >= 0) {
                    problemPerson.setPersonType("2");
                } else {
                    problemPerson.setPersonType("3");
                }
                problemPerson.setProblemtype(problemtype.toString());
                if (problemPerson.getId() != null) {
                    this.problemPersonDaoAop.update(problemPerson);
                } else {
                    this.problemPersonDao.save(problemPerson);
                }
            }
        } else if (problemPerson.getId() != null) {
            problemPerson.setActive(Boolean.valueOf(false));
            this.problemPersonDaoAop.update(problemPerson);
        }
        if (result) {
            person.setCensorStatus("003");
        } else {
            person.setCensorStatus("004");
        }
        person.setCensorTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public final void censorSaveProblemPersonNoPassCensorStatus(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        String idNumber = person.getIdNumber();
        String name = person.getRealName();
        ProblemPerson problemPerson = new ProblemPerson();
        ProblemPerson query = new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose("0");
        List list = this.problemPersonDao.findByPersonIdForMax(query);
        problemPerson.setCreateTime(new Date());
        problemPerson.setComparisonDate(new Date());
        problemPerson.setDispose("0");
        boolean result = true;
        boolean problemChange = false;
        StringBuffer problemtype = new StringBuffer();
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
            problemtype.append(backgroundApproval.getApprovalreason()).append(",");
            result = false;
        }
        if (!result) {
            String[] problemtypes;
            for (String type : problemtypes = problemtype.toString().split(",")) {
                if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(type = type.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a")) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(type)) continue;
                boolean existsFlag = false;
                for (ProblemPerson p : list) {
                    String[] dbProblemtypes;
                    for (String dbType : dbProblemtypes = p.getProblemtype().split(",")) {
                        if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(dbType) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(dbType) || !StringUtil.trim((String)(dbType = dbType.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a"))).equals(StringUtil.trim((String)type))) continue;
                        existsFlag = true;
                        break;
                    }
                    if (!existsFlag) continue;
                    break;
                }
                if (existsFlag) continue;
                problemChange = true;
            }
        }
        person.setCensorStatus("004");
        person.setCensorCriminalStatus("004");
        person.setCensorTime(new Date());
        this.personDaoAop.updateSelective(person);
        if (result || !problemChange) {
            return;
        }
        if (!result) {
            problemtype.deleteCharAt(problemtype.length() - 1);
        }
        if (person == null) {
            logger.error("\u5f02\u5e38\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
            return;
        }
        SecurityCompanyPerson securityCompanyPerson = this.securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(Boolean.valueOf(true));
        problemPerson.setUpdateBy("systemAutoCriminal");
        problemPerson.setIdnumber(idNumber);
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        if (securityCompanyPerson != null && securityCompanyPerson.getCompany() != null) {
            problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
            problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
            if (StringUtil.isNotEmpty((String)securityCompanyPerson.getCompany().getOrgId())) {
                problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
            }
            problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
            problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
        }
        problemPerson.setPhone(person.getPhone());
        problemPerson.setName(person.getRealName());
        problemPerson.setSex(person.getGender());
        problemPerson.setPersonid(person.getId());
        problemPerson.setUpdateflag(Boolean.valueOf(true));
        if (!result) {
            if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(problemtype.toString()) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(problemtype.toString())) {
                problemPerson.setPersonType("1");
            } else if (problemtype.toString().indexOf("\u5728\u9003") > 0) {
                problemPerson.setPersonType("2");
            } else {
                problemPerson.setPersonType("3");
            }
            problemPerson.setProblemtype(problemtype.toString());
            if (problemPerson.getId() != null) {
                this.problemPersonDaoAop.update(problemPerson);
            } else {
                this.problemPersonDao.save(problemPerson);
            }
        }
    }

    public final void censorSaveProblemPersonCriminal(SecurityPerson person, List<BackgroundApproval> backgroundApprovals) {
        String idNumber = person.getIdNumber();
        String name = person.getRealName();
        ProblemPerson problemPerson = new ProblemPerson();
        ProblemPerson query = new ProblemPerson();
        query.setPersonid(person.getId());
        query.setDispose("0");
        List list = this.problemPersonDao.findByPersonIdForUnDispose(query);
        if (list != null && list.size() > 0) {
            problemPerson = (ProblemPerson)list.get(0);
        } else {
            problemPerson.setCreateTime(new Date());
            problemPerson.setDispose("0");
        }
        problemPerson.setComparisonDate(new Date());
        if (person == null) {
            logger.error("\u5f02\u5e38\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
            return;
        }
        SecurityCompanyPerson securityCompanyPerson = this.securityCompanyPersonDao.findByPersonId(person.getId());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setActive(Boolean.valueOf(true));
        problemPerson.setUpdateBy("systemAuto");
        problemPerson.setIdnumber(idNumber);
        problemPerson.setIncumbencyStatus(person.getIncumbencyStatus());
        if (securityCompanyPerson != null && securityCompanyPerson.getCompany() != null) {
            problemPerson.setCompanyid(securityCompanyPerson.getCompany().getId());
            problemPerson.setCompanyname(securityCompanyPerson.getCompany().getName());
            if (StringUtil.isNotEmpty((String)securityCompanyPerson.getCompany().getOrgId())) {
                problemPerson.setOrgId(Long.valueOf(securityCompanyPerson.getCompany().getOrgId()));
            }
            problemPerson.setOrgName(securityCompanyPerson.getCompany().getOrgName());
            problemPerson.setAreaCode(securityCompanyPerson.getCompany().getAreaCode());
        }
        problemPerson.setPhone(person.getPhone());
        problemPerson.setName(person.getRealName());
        problemPerson.setSex(person.getGender());
        problemPerson.setPersonid(person.getId());
        boolean result = true;
        boolean existsFlag = false;
        StringBuffer problemtype = new StringBuffer();
        for (BackgroundApproval backgroundApproval : backgroundApprovals) {
            if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
            problemtype.append(backgroundApproval.getApprovalreason()).append(",");
            result = false;
        }
        problemPerson.setUpdateflag(Boolean.valueOf(true));
        List dbList = this.problemPersonDao.findByPersonIdForMax(query);
        if (!result) {
            String[] problemtypes;
            block1: for (String type : problemtypes = problemtype.toString().split(",")) {
                if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(type = type.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a")) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(type)) continue;
                for (ProblemPerson p : dbList) {
                    String[] dbProblemtypes;
                    for (String dbType : dbProblemtypes = p.getProblemtype().split(",")) {
                        if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(dbType) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(dbType) || !StringUtil.trim((String)(dbType = dbType.replaceAll("\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55", "\u8fdd\u6cd5\u72af\u7f6a"))).equals(StringUtil.trim((String)type))) continue;
                        existsFlag = true;
                        break;
                    }
                    if (!existsFlag) continue;
                    continue block1;
                }
            }
            if (!existsFlag) {
                problemtype.deleteCharAt(problemtype.length() - 1);
                if ("\u59d3\u540d\u4fe1\u606f\u6709\u8bef".equals(problemtype.toString()) || "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728".equals(problemtype.toString())) {
                    problemPerson.setPersonType("1");
                } else if (problemtype.toString().indexOf("\u5728\u9003") > 0) {
                    problemPerson.setPersonType("2");
                } else {
                    problemPerson.setPersonType("3");
                }
                problemPerson.setProblemtype(problemtype.toString());
                if (problemPerson.getId() != null) {
                    this.problemPersonDaoAop.update(problemPerson);
                } else {
                    this.problemPersonDao.save(problemPerson);
                }
            }
        } else if (problemPerson.getId() != null) {
            problemPerson.setActive(Boolean.valueOf(false));
            this.problemPersonDaoAop.update(problemPerson);
        }
        if (result) {
            person.setCensorStatus("003");
            person.setCensorCriminalStatus("003");
        } else {
            person.setCensorStatus("004");
            person.setCensorCriminalStatus("004");
        }
        person.setCensorTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public final List<BackgroundApproval> censor(BackgroundApprovalDto dto) {
        String name = dto.getRealName();
        if (StringUtil.isEmpty((String)name)) {
            name = this.clientUtil.getName(dto.getBusinessid(), dto.getBusinesstype());
        }
        if (StringUtil.isEmpty((String)name)) {
            throw new ArsException("businessid:" + dto.getBusinessid() + ",businesstype:" + dto.getBusinesstype() + "\u65e0\u6cd5\u83b7\u53d6\u5230\u59d3\u540d!");
        }
        dto.setRealName(name);
        List<BackgroundApproval> backgroundApprovals = this.getCensorResult(dto);
        if (!"15".equals(dto.getBusinesstype()) && backgroundApprovals != null && backgroundApprovals.size() > 0) {
            this.backgroundApprovalDao.delete(dto);
            this.backgroundApprovalDao.batchSave(backgroundApprovals);
        }
        return backgroundApprovals;
    }

    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto, boolean needCZ) {
        return null;
    }

    public final String getCensorStatus(BackgroundApprovalDto dto) {
        List<BackgroundApproval> list = this.censor(dto);
        for (BackgroundApproval detail : list) {
            if (!"004".equals(detail.getApprovalstate())) continue;
            return "004";
        }
        return "003";
    }

    public final String getCensorResult(String idNumber, String name) {
        BackgroundApprovalDto dto = new BackgroundApprovalDto();
        dto.setIdNumber(idNumber);
        dto.setRealName(name);
        List<BackgroundApproval> backgroundApprovals = this.getCensorResult(dto);
        return this.getCensorResult(backgroundApprovals);
    }
}

