package com.bcxin.ars.webservice.police;

import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.webservice.police.enums.ResultType;

import java.util.List;
import java.util.Map;

/**
 *
 * 公安部接口调用服务
 * @Auther linqinglin
 * @date 2021/7/1 21:55
 */
public interface SecurityInterfaceService {

    Map<String,PersonBaseInfo> getPersonInfo(List<String> idnums, ResultType resultType);

    Map<String,PersonBaseInfo> getNewPersonInfo(List<String> idnums);

    /**
     * 保安员背景筛查
     * @param personList
     */
    void censorPerson(List<SecurityPerson> personList);

    /**
     * 资格证报名背景筛查
     * @param personList
     */
    void censoRenrollQualification(List<Personcertificate> personList);


    /**
     * 保安员背景筛查
     * @param personList
     */
    void censorNewPerson(List<SecurityPerson> personList);

    /**
     * 资格证报名背景筛查
     * @param personList
     */
    void censorNewQualification(List<Personcertificate> personList);

}
