
//设置div内tr的宽度，设置样式用
function setTdWidth(width){
   var width = '.width'+width+' {width:'+width+'%;border-width:0px;}';
       return width;
}
//设置宽度的样式，参数为div的name和宽度的集合
function setTdWidthes(widthList) {
    var styleWidth = '';
    for(var i = 0; i < widthList.length; i++) {
        styleWidth = styleWidth+setTdWidth(widthList[i]);
    }
    return styleWidth;
}

//设置div内td的宽度，设置样式用
function setTrHeight(height) {
    var height = '.height'+height+' {height:'+height+'px;}';
    return height;
}

//设置div内td的宽度，设置样式用
function setTrHeightes(heightList) {
    var styleHeight = '';
    for(var i = 0; i < heightList.length; i++) {
        styleHeight = styleHeight+setTrHeight(heightList[i]);
    }
    return styleHeight;
}

function setHead(tableStyle) {
    var head = '<meta charset="utf-8">' +
        '<style type="text/css">'+
        'table,td{text-align: center;vertical-align:middle;border-style: solid;  border-width:1px;}'+
        'table,tr{height: 40px;}'+
        tableStyle+
        '</style>';
    head = setTag(head,"head")
    return head;
}

//保安服务公司许可(详情)打印元素
function getNameValueDetail(name,data){
    var map = {"公司名称":data.companyname,"电话":data.tel,"公司地址":data.address,"邮编":isNullEmpty(data.zipcode),"经营范围":data.management,
        "企业类型":data.enterprisetype,"注册资金":'<strong>'+isNullEmpty(data.regcapital)+'（万元）</strong>',"注册资本验资或评估机构":isNullEmpty(data.assessmentorg),
        "货币资本":isNullEmpty(data.currency),"资产评估价值":isNullEmpty(data.currencyvalue),"拟任法定代表人":data.representative,"手机及固定电话":data.phone,
        "公司管理人员数":data.companymanger,"专业技术人员数":data.technologynum,"公司用房面积":data.areanum,"产权归属":data.ascription,
        "专用运输车辆数":isNullEmpty(data.ascriptionvehicle),"防爆枪支数":isNullEmpty(data.gunnum),"提交办事区域":isNullEmpty(data.szss)}
    return map[name]|| "";
}

//设置td，content是内容，colspan是合并列，rowspan是合并列，style是样式名
function setTd(content,colspan,rowspan,style) {
    return '<td rowspan="'+rowspan+'" colspan="'+colspan+'" class="'+style+'">'+content+'</td>';
}

//设置元素，content是内容，colspan是合并列，rowspan是合并列，style是样式名 值通过getNameValueDetail获取后面是值对应的参数：比如valueColspan 是值合并列的数量
function setNameAndValue(content,colspan,rowspan,style,valueColspan,valueRowspan,valueStyle,data) {
    return setTd(content,colspan,rowspan,style)+setTd(getNameValueDetail(content,data),valueColspan,valueRowspan,valueStyle);
}

//tr设置4个Td，content是内容，colspan是合并列，rowspan是合并行， 值通过getNameValueDetail获取后面是值对应的参数：比如valueColspan 是值合并列的数量
function setTrHave4Td(content1,colspan1,rowspan1,valueColspan1,valueRowspan1,
                  content2,colspan2,rowspan2,valueColspan2,valueRowspan2,data) {
    //分别调用设置一个元素的值
    var tr = '<tr>'+setNameAndValue(content1,colspan1,rowspan1,"",valueColspan1,valueRowspan1,"",data)+
        setNameAndValue(content2,colspan2,rowspan2,"",valueColspan2,valueRowspan2,"",data)+'</tr>';
    return tr;
}

//设置表格的默认值，默认4个Td字段名占用1行1列，对应的值为1行；
// content1/content2表示字段值;valueColspan1/valueColspan2表示：字段名对应值所占列表的列数
function setTr4TdDefalut(content1,valueColspan1,content2,valueColspan2,data) {
    //分别调用设置一个元素的值
    var tr = '<tr>'+setNameAndValue(content1,1,1,"",valueColspan1,1,"",data)+
        setNameAndValue(content2,1,1,"",valueColspan2,1,"",data)+'</tr>';
    return tr;
}


//设置tr，content是内容，colspan是合并列，rowspan是合并列，style是样式名 值通过getNameValueDetail获取后面是值对应的参数：比如valueColspan 是值合并列的数量
function setTr2TdDefalut(content1,valueColspan1,data) {
    //分别调用设置一个元素的值
    var tr = '<tr>'+setNameAndValue(content1,1,1,"",valueColspan1,1,"",data)+'</tr>';
    return tr;
}

//一行只有一个td,content是td里面的内容，
function setTrHave1Td(trstyle,content,colspan,rowspan,tdstyle) {
    var tr = '<tr class="'+trstyle+'">'+setTd(content,colspan,rowspan,tdstyle)+'</tr>';
    return tr;
}

//设置单元格的宽度，tdWidth的长度表示表格的列数，tdWidth的值代表每一列的宽度
function setThead(tdWidth,content){
    var tdWidthStr ='';
    if(content.length == 0){
        tdWidthStr = tdWidthStr +'<thead style="visibility: hidden;">'+ '<tr  style="height: 0px;">';
        for (var i = 0; i < tdWidth.length; i++) {
            tdWidthStr = tdWidthStr + '<td width="'+tdWidth[i]+'%" style="border-width:0px;"></td>';
        }
    }
    else {
        tdWidthStr = tdWidthStr +'<thead>'+ '<tr>';
        for (var j = 0; j < tdWidth.length; j++) {
            tdWidthStr = tdWidthStr + '<td width="'+tdWidth[j]+'%">'+content[j]+'</td>';
        }
    }
    tdWidthStr = tdWidthStr +'</tr>'+'</thead>';
    return tdWidthStr;
}

//默认是无样式
function setTdList(tdList) {
    var tdListStr = '';
    for(var i=0;i<tdList.length;i++){
        tdListStr =  tdListStr + setTd(tdList[i],1,1,"");
    }
    return tdListStr;
}

//审批进度表的逻辑
function setTbody(data) {
    var tbody = '<tdbody>';
    if(data != null && data.length>0){
        for(var i = 0;i<data.length;i++){
            if(data[i].approvalid != null && data[i].approvalperson != null && data[i].approvalorg != null){
                var tdList = [(i+1),data[i].approvaldate == null?"":new Date(data[i].approvaldate).format("yyyy-MM-dd hh:mm:ss"),
                    data[i].approvalperson==null?"没有配置下一级审批人员":data[i].approvalperson,
                    isNullEmpty(data[i].approvalstate), isNullEmpty(data[i].approvalreason),
                    (data[i].approvalstate != null && data[i].approvalperson != null?data[i].approvalorg:"")];
                tbody = tbody +'<tr>'+setTdList(tdList)+'</tr>';
            }
        }
    }else{
        tbody = tbody +'<tr>'+
            '<td colspan="6" class="text-center">暂无相关数据！</td>'+
            '</tr>';
    }
    tbody = tbody+'</tbody>';
    return tbody;
}

//字段名加粗的方法
function setTdB(content,contentValue,colspan){
    contentValue = isNullEmpty(contentValue);
    var td = setTd(content,1,1,"bold-font")+setTd(isNullEmpty(contentValue),colspan,1,"");
    return td;
}

//字段名加粗的方法
function setManyRowTdB(content,rowspan,contentValue,colspan){
    var td = setTd(content,1,rowspan,"bold-font")+setTd(contentValue,colspan,1,"left-text");
    return td;
}
//字段名加粗的方法
function setTr2Td(content,contentValue,colspan){
    var tr = setTdB(content,isNullEmpty(contentValue),colspan);
    return setTag(tr,"tr");
}

//字段名加粗的方法
function setTr4Td(content1,contentValue1,colspan1,content,contentValue,colspan){
    var tr = setTdB(content1,contentValue1,colspan1)+setTdB(content,contentValue,colspan);
    return setTag(tr,"tr");
}

//表格的开始
function set3Td(content1,rowspan,content2,content2Value,colspan) {
    var tr = setTd(content1,1,rowspan,"bold-font")+setTdB(content2,isNullEmpty(content2Value),colspan);
    return setTag(tr,"tr");
}
//表格的开始
function set3TdB(content1,colspan1,content2,colspan2,content3,colspan3) {
    var tr = setTd(content1,colspan1,1,"bold-font")+setTd(isNullEmpty(content2),colspan2,1,"bold-font")+
        setTd(isNullEmpty(content3),colspan3,1,"bold-font")
    return setTag(tr,"tr");
}

//给字符串加标签
function setTag(str,tagName){
    return  '<'+tagName+'>'+str+'</'+tagName+'>';
}
//给字符串加标签带样式
function setTagStyle(str,tagName,style){
    return  '<'+tagName+' class="'+style+'">'+str+'</'+tagName+'>';
}
//给字符串加双重标签加样式
function set2TagStyle(conten,tagIn,styleIn,tagOut,styleOut){
    var str = setTagStyle(conten,tagIn,styleIn);
    return setTagStyle(str,tagOut,styleOut);
}
//提供材料目录,1代表申请设立，2代表变更
function getTGCLMLList(type) {
    var chekBox = '<input type="checkbox" class="check-box">';
    var list1 =[chekBox+"设立申请书<span style=\"color: blue;margin-left: 0px\" >（应当载明拟设立公司或培训机构的基本情况）。</span>",chekBox+"注册资本认缴金额",
        chekBox+"拟任的保安服务公司法定代表人、总经理、副总经理等管理人员的有效身份证件、简历，" +
        "保安师资格证书复印件，5年以上军队、公安、安全、审判、检察、司法行政或者治安保卫、保安经营管理工作经验证明。" ,
        chekBox+"<span style=\"color: blue;margin-left: 0px\" >拟设保安服务公司住所的所有权或者使用权的有效证明文件和提供保安服务所需的有关设备、交通工具等材料；" +
        chekBox+"保安培训所需场所、设施等教学条件证明。</span>",
        chekBox+"<span style=\"color: blue;margin-left: 0px\" >专业技术人员名单及资格证明；"+chekBox+"保安培训所需的师资力量。</span>",
        chekBox+"组织机构和保安服务管理制度、岗位责任制度、保安员管理制度材料。",
        chekBox+"企业名称预先核准通知书；<span style=\"color: blue;margin-left: 0;\">" +chekBox+"依法设立保安服务公司或依法设立的具有法人资格的学校、职业培训机构的证明材料。</span>"];
    var list2 = [chekBox+"<span style=\"color: red;margin-left: 0px\" >变更申请书（应当载明变更项目）。</span>",chekBox+"保安服务（培训）许可证副本。",
        chekBox+"变更单位名称：保安服务公司、学校、职业培训机构更名的有效证明文件。",
        chekBox+"变更单位住所：变更后住所的所有权或者使用权的有效证明文件，保安培训场所理论课教室、训练场地符合条件的证明材料。",
        chekBox+"保安服务公司变更法定代表人：法定代表人变更证明文件、有效身份证件和保安师资格证书复印件、简历、相关工作经验证明。",
        chekBox+"保安培训机构变更法定代表人：法定代表人变更证明文件、有效身份证复印件。",
        chekBox+"保安服务公司变更服务范围：提供保安服务所需的有关设备、交通工具等材料，专业技术人员名单和法律、行政法规有资格要求的资格证明。",
        chekBox+"保安培训机构变更培训内容：开展培训所需设施、设备等证明材料及相应师资人员的资格证明文件复印件。",
        chekBox+"保安服务公司变更注册资本：注册资本验资证明、国有资产评估文件复印件。"];
    var map = {"1":list1,"2":list2};
    return map[type]|| "";
}

//特殊方法，提供材料目录
function setTGCLML(content,list,row) {
    var tgclml= setManyRowTdB(content,row,list[0],4);
    for(var i = 1;i<list.length;i++){
        var tr = setTd(list[i],4,1,"left-text");
        tr = setTag(tr,"tr");
        tgclml = tgclml + tr;
    }
    return tgclml;
}

//申请单位法定代表人签名盖章
function setQMGZ(content,name,time) {
    var contentValue = setTagStyle("对上述填写和提交的材料真实有效性负责","p","bold-font")+'<br>' +
                       setTag("法定代表人姓名："+name,"p") +setTagStyle(time,"p","right bold-font");
    return setTr2Td(content,contentValue,4);
}

//如果为空用““代替,不为空则是本身
function isNullEmpty(content) {
    return content == null ?"":content;
}

function set2TdAnd3P(content,p1,p2,p3){
    var contentValue =set2TagStyle(isNullEmpty(p1),"p","","div","left")+
        setTagStyle(setTag("签名："+isNullEmpty(p2),"p")+setTag(isNullEmpty(p3),"p"),"div","right");
    return  setTr2Td(content,contentValue,4);
}
function setset2TdAnd2P(content,p1,p2){
    var contentValue = setTagStyle(setTag(p1,"p")+setTag(p2,"p"),"div","right");
    return setTr2Td(content,contentValue,4);
}






