package com.bcxin.ars.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginInterceptor implements HandlerInterceptor  {

	private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);
	
	@Override
	public void afterCompletion(HttpServletRequest arg0,
			HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {
		
	}

	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
			Object arg2, ModelAndView arg3) throws Exception {
		
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object obj) throws Exception {
		log.error("request url:"+request.getRequestURL().toString());
		if(!request.getRequestURL().toString().contains("login")) {
			log.error("request Params:" + JSONObject.toJSONString(request.getParameterMap()));
			if(request.getRequestURL().toString().contains("yztAuth/ssoLogin.do")) {
				String referer = request.getHeader("Referer");
				log.error("=========> 北京单点登录yztAuth.ssoLogin.Referer:"+referer);
				if(StringUtil.isNotEmpty(referer)&&referer.contains("serverType")){
					String type="&serverType"+referer.split("serverType")[1];
					log.error("=========> 北京单点登录yztAuth.ssoLogin.type:"+type);
				}
			}
		}
		String referer = request.getHeader("Referer");
		log.error("=========> Referer:"+referer);
		System.out.println("=========> Referer:"+referer);
		String initiatorChain = request.getHeader("Origin");
		log.error("=========> Request initiator chain: " + initiatorChain);
		System.out.println("=========> Request initiator chain: " + initiatorChain);
		SecurityContext.currentNative.set(Long.valueOf((String)request.getServletContext().getAttribute(Constants.CURRENT_NATIVE)));

		return true;
//		if(request.getRequestURL().indexOf("login") >= 0) {
//			return true;
//		}
//		User logUser = (User) request.getSession().getAttribute(Constants.LOGIN_USER);
////		System.out.println(logUser);
//		if(null != logUser) {
//			if(logUser.getPlatform() == 4){
//				request.getRequestDispatcher("/iframe/apply-login.jsp").forward(request, response);
//			}else{
//				return true;
//			}
//		} else {
//			request.getRequestDispatcher("/login.jsp").forward(request, response);
//		}
//		return false;
	}
	
}
