package com.bcxin.ars.web.controller;

import cn.hutool.core.util.StrUtil;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.AppraiseConstants;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;

@Controller
@RequestMapping("/")
public class IndexController {
	
	private Logger logger = LoggerFactory.getLogger(IndexController.class);
	
	@Autowired
	private ArsUtil arsUtil;
	
	@Autowired
	private UserService userService;
	@Autowired
	private ConfigUtils configUtils;
	@Autowired
	private LoginLogService loginLogService;
	@Autowired
	private ConferenceAccountDao conferenceAccountDao;
	@Autowired
	private ModuleMenuService moduleMenuService;
	@Autowired
	private PoliceService policeService;
	@Value("${login-timeout}")
	private int loginTimeout = 10;
	@Autowired
	private SysareaService sysareaService;
	@Autowired
	private SecurityCompanyService securityCompanyService;

	/**
	 * <b>Function </b> 登出
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月6日 下午5:12:01
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("logout")
	public void logOut(HttpServletRequest request, HttpServletResponse response){
		request.getSession().removeAttribute(Constants.LOGIN_USER);
		request.getSession().removeAttribute(Constants.SESSION_ID);
		request.getSession().removeAttribute(Constants.SINGLELOGINBJ_UNIQUEID);
		try {
			ServletContext servletContext = request.getServletContext();
			String rootPath = servletContext.getContextPath();
			if(request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN) != null){
				String SINGLELOGINBJ_TOKEN = request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN).toString();
				logger.error("SINGLELOGINBJ_TOKEN:"+SINGLELOGINBJ_TOKEN);
				request.getSession().removeAttribute(Constants.SINGLELOGINBJ_TOKEN);
				new Thread(()->{
					HttpUtil.get(configUtils.bj_zrr_singleLogin_url+AppraiseConstants.SINGLELOGINBJ__URL_LOGOUT + SINGLELOGINBJ_TOKEN);
				}).start();
			}
			response.sendRedirect(rootPath + "/login.jsp");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	/***
	 *  广西内网登陆根据
	 * @param city 城市参数
	 * @return
	 */
	@RequestMapping("gx/login")
	public String login(HttpServletRequest request,String city) {
		request.getSession().setAttribute("city",city);
		Sysarea sysarea = sysareaService.findByCode(city);
		if(sysarea!=null){
			//城市名称
			request.getSession().setAttribute("cityName",sysarea.getName());
		}
		return "login";
	}
	//@RequestMapping("map/index")
	public String mapIndex(HttpServletRequest request) {
		return "/map/index";
	}
	@RequestMapping("saas/map/index")
	public String mapIndexSaaS(HttpServletRequest request) {
		return "/map/indexSaaS";
	}



	@RequestMapping("index")
	public String backIndex(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap){
		String page = "backIndex";
		try {
			//北京ca认证
            if(Constants.YES.equals(configUtils.getValueByKey(Constants.CA_SWITCH))){
                String dnname = request.getHeader("dnname");
				if(StrUtil.isNotEmpty(dnname)){
					try {
						modelMap.put("dnname", URLEncoder.encode(DES3.encode(dnname),"UTF-8"));
					} catch (Exception e) {
						modelMap.put("msg","登录失败：证书主题解析错误");
					}
					return "caLogin";
				}
                dnname = request.getParameter("dnname");
                if(StrUtil.isNotEmpty(dnname)){
                    AjaxResult result = bjCaLogin(dnname,request);
                    if(!result.isSuccessful()){
                        throw new ArsException(result.getMsg());
                    }
                }
            }
			ServletContext servletContext = request.getServletContext();
			String rootPath = servletContext.getContextPath();
			User loginUser = arsUtil.getCurrentUser();
			//如果用户为空，则从shiro获取信息
			if(loginUser==null){
				Subject currentUser = SecurityUtils.getSubject();
				if(currentUser!=null && currentUser.getPrincipal()!=null) {
					loginUser = (User) currentUser.getPrincipal();
					//机构信息
					Police police = policeService.findById(loginUser.getOrgid());
					if (police != null) {
						loginUser.setPolice(police);
					}
					/***
					 * 城市区域
					 */
					String cityAreaCode = police.getAreacode().substring(0, 4) + "00";
					loginUser.setCityAreaCode(cityAreaCode);
					loginUser.setAreasList(policeService.findDataPoliceForUserID(loginUser.getId()));
					arsUtil.setCurrentUser(loginUser, 1000 * 120 * loginTimeout);
					/*//登录次数+1
					if (null != loginUser.getLoginNum()) {
						loginUser.setLoginNum(loginUser.getLoginNum() + 1);
					} else {
						loginUser.setLoginNum(1);
					}
					//登录时间为当前时间
					loginUser.setLoginDate(new Date());
					userService.updateLoginState(loginUser);
					//登陆日志
					loginLogService.logIn(request);*/
				}
			}

			if(loginUser == null) {
				response.sendRedirect(rootPath+"/login.jsp");
			}else {
				User currentUser = userService.findById(loginUser.getId());
				//外网获取华为帐号密码信息
				if(!configUtils.isIntranet()){
					ConferenceAccount conferenceAccount =  conferenceAccountDao.selectByUserId(currentUser.getId());
					if(conferenceAccount!=null){
						//帐号
						currentUser.setHuaweiAccout(conferenceAccount.getAccount());
						//密码
						currentUser.setHuaweiPwd(conferenceAccount.getPassword());
					}

				}
				currentUser.setSessionId(loginUser.getSessionId());
				currentUser.setToken(loginUser.getToken());
				currentUser.setCompanyUserId(loginUser.getCompanyUserId());
				currentUser.setCompanyUsername(loginUser.getCompanyUsername());
				//加入百课堂所需的token
				currentUser.setBktToken(loginUser.getBktToken());
				currentUser.setRoles(loginUser.getRoles());
				currentUser.setPermissionList(loginUser.getPermissionList());
				currentUser.setPolice(loginUser.getPolice());
				currentUser.setApprovalroleid(loginUser.getApprovalroleid());
				currentUser.setCityAreaCode(loginUser.getCityAreaCode());

				//大屏地址
				currentUser.setPersonDataURL(loginUser.getPersonDataURL());
				currentUser.setCompanyDataURL(loginUser.getCompanyDataURL());
				currentUser.setPoliceDataURL(loginUser.getPoliceDataURL());
				//只要广西
				if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && loginUser.getCity()!=null) {
					//城市信息
					currentUser.setCityName(loginUser.getCityName());
					currentUser.setCity(loginUser.getCity());
					currentUser.setUserinfo(loginUser.getUserinfo());
				}
				//陕西
				if(Constants.SHANGXI.equals(configUtils.getCurrentNative()) && loginUser.getCity()==null) {
					if(loginUser.getPlatform() !=1&&loginUser.getPlatform() !=4){
						SecurityCompany company = securityCompanyService.findByUserid(loginUser.getId());
						if(company.getAreaCode()!=null){
							String cityAreaCode = company.getAreaCode().substring(0, 4) + "00";
							currentUser.setCityAreaCode(cityAreaCode);
						}
					}
				}
				request.getSession().setAttribute(Constants.LOGIN_USER, currentUser);
				request.getSession().setAttribute(Constants.SESSION_ID, loginUser.getSessionId());
				if(loginUser.getPlatform() == 4){
					page = null;
					response.sendRedirect(rootPath+"/iframe/apply-login.jsp");
				}else if(loginUser.getPlatform() == 1){
					page="menuIndex";
					if("1".equals(request.getParameter("mobile"))){
						page="mobile/search";
					}else {
						if(loginUser.getPermissionList() != null){
							modelMap.addAttribute("menuList",moduleMenuService.setMenuTree(loginUser.getPermissionList()));
						}else {
							modelMap.addAttribute("menuList", moduleMenuService.findForMenu());
						}
					}
				}else{
					if("1".equals(request.getParameter("localTest"))){
						page="arsIndex";
					}
				}

				if(StringUtil.isNotEmpty(request.getParameter("redirect_uri"))){
					response.sendRedirect(rootPath+"/"+request.getParameter("redirect_uri"));
				}
			}
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
		}
		return page;
	}

	private AjaxResult bjCaLogin(String dnname,HttpServletRequest request){
		AjaxResult result = new AjaxResult();
		String idnum = null;
		try {
			dnname = DES3.decode(dnname);
			dnname = new String(dnname.getBytes("ISO8859-1"),"UTF-8");
			logger.error("北京ca认证登录:{}",dnname);
			for (String data : dnname.split(",")) {
				String[]datas = data.split("=");
				System.out.println(datas[0].trim());
				System.out.println(datas[1].trim());
				if("CN".equals(datas[0].trim())){
					String userInfo = datas[1].trim();
					idnum = userInfo.split(" ")[1];
				}
			}
		}catch (Exception e){
			e.printStackTrace();
			return AjaxResult.error("登录失败：证书主题解析错误");
		}

		if(StrUtil.isEmpty(idnum)){
			return AjaxResult.error("登录失败：无法从证书主题中获取到身份证号");
		}

		//登陆信息
		UsernamePasswordToken token = new UsernamePasswordToken(idnum, "");
		Subject currentUser = SecurityUtils.getSubject();
		token.setRememberMe(false);
		//北京ca认证登录标记
		token.setHost(Constants.BJ_CA_SSO);
		try {
			currentUser.login(token);
		} catch (AuthenticationException e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(Constants.CA_PASSWORDERROR_MESSAGE);
			return result;
		}
		//判断是否登录成功！
		if (currentUser.isAuthenticated()) {
			Session session = currentUser.getSession();
			User user = userService.findByIdNum(idnum,Constants.PLATFORM_POLICE+"");
			//功能权限
			//机构信息
			Police police = policeService.findById(user.getOrgid());
			if(police!=null){
				user.setPolice(police);
			}
			//设置数据大屏链接
			userService.setDateView(user);
			/***
			 * 城市区域
			 */
			String cityAreaCode =police.getAreacode().substring(0,4)+"00";
			user.setCityAreaCode(cityAreaCode);
			//获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
			user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
			//登录次数+1
			if( null!= user.getLoginNum() ) {
				user.setLoginNum(user.getLoginNum()+1);
			}else{
				user.setLoginNum(1);
			}
			//登录时间为当前时间
			user.setLoginDate(new Date());
			userService.updateLoginState(user);
			user.setSessionId(session.getId().toString());
			arsUtil.setCurrentUser(user,1000*120*loginTimeout);
			result.setData(user);
			result.setSuccessful(true);
			loginLogService.logIn(request);
		}else{
			result.setSuccessful(false);
			result.setMsg(Constants.CA_PASSWORDERROR_MESSAGE);
		}
		return result;
	}


	
	@RequestMapping("companyInit")
	public String companyInit(HttpServletRequest request) {
		return "/map/initCompany";
	}
	
	@RequestMapping("orgInit")
	public String orgInit(HttpServletRequest request) {
		return "/map/initOrg";
	}
	
	@RequestMapping("roleInit")
	public String roleInit(HttpServletRequest request) {
		return "/map/initRole";
	}
	

	@RequestMapping("userInit")
	public String userInit(HttpServletRequest request) {
		return "/map/initUser";
	}
	
	public static String getRemoteIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if(ip.equals("0:0:0:0:0:0:0:1")) {
        	ip = "127.0.0.1";
        }
        return ip;
    }


    /***
     * 发送异常数据短信
     * @param request
     * @return
     */
    @RequestMapping("sendException")
    public  @ResponseBody AjaxResult sendException(HttpServletRequest request) {
        AjaxResult result = new AjaxResult();


		Map<String, Object> serviceBeans = SpringUtils.getBeansByAnnotation(DataSyncOutAnnotation.class);
		System.out.println(serviceBeans);
       /* try {
			indexService.sendException();
			result.setSuccessful(true);
			result.setMsg("发送完成！");
		}catch (Exception e){
			result.setSuccessful(false);
			result.setMsg("发送失败！");
		}*/
        return result;
    }


}
