package com.bcxin.ars.rest.zw;

import java.util.*;

import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.sb.PersoncertificateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.rest.sys.ApprovalController;
import com.bcxin.ars.service.zw.PctinfoService;

/**
 * 指纹
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年9月8日 下午5:08:07
 * @注意事项 </b>
 * <b>
 */
@Controller
@RequestMapping("pctinfo")
public class PctinfoController {

	private Logger logger = LoggerFactory.getLogger(PctinfoController.class);

	@Autowired
	private PctinfoService pctinfoService;

	@Autowired
	private PersoncertificateService personcertificateService;
	
	@RequestMapping("findByIdnumber/{idnumber}")
	public @ResponseBody AjaxResult findByIdnumber(@PathVariable String idnumber) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Pctinfo pctinfo = pctinfoService.findByIdnumber(idnumber);
			if(pctinfo != null) {
				result.setSuccessful(true);
				result.setData(pctinfo);
			}else {
				result.setMsg("暂无此人员的指纹信息，请在为保安员录入指纹！");
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("findByIdnumArr")
	public @ResponseBody AjaxResult findByIdnumArr(String[] cardnumberArr) throws Exception {
		AjaxResult result = new AjaxResult();
		try {

			List<Pctinfo> pctinfoList = new ArrayList<>();
			String s="";
			for (int i = 0; i < cardnumberArr.length; i++) {
				Pctinfo pctinfo = pctinfoService.findByIdnumber(cardnumberArr[i]);
				if(pctinfo != null) {
					//	result.setSuccessful(true);
					pctinfoList.add(pctinfo);
					//	result.setData(pctinfo);
				}else {
					Personcertificate personcertificate = personcertificateService.getCardStateByCardnumber(cardnumberArr[i]);
					s+=personcertificate.getName()+",";
					//	result.setMsg("暂无此人员的指纹信息，请在为保安员录入指纹！");
					//	result.setSuccessful(false);
				}
			}

			if(pctinfoList.size()<=0){
				result.setSuccessful(false);
				result.setMsg(s+"暂无此人员的指纹信息，请在为保安员录入指纹！");
			}else{
				result.setSuccessful(true);
				result.setData(pctinfoList);
//				if(!s.equals("")){
//					result.setMsg(s+"暂无此人员的指纹信息，请在为保安员录入指纹！");
//				}
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
