package com.bcxin.ars.rest.util;

import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.util.Constants;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/****
 * shiro与cas集成用户登录和授权用的realm
 */
public class CasRealm extends org.apache.shiro.cas.CasRealm {
    /**
     * 日志
     */
    private Logger log = LoggerFactory.getLogger(CasRealm.class);
	@Autowired
	private UserService userService;

	@Autowired
	private PermissionService permissionService;
	@Override
	public void setName(String name) {
		super.setName("CAS Realm");
	}
	@SuppressWarnings("unchecked")
	@Override
	protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {

	    /*
	    * 1.用户的请求首先到达项目A的ShiroFilter。
2.若用户访问需认证的URL(非user拦截器)，由于未进行认证，Subject的isAuthenticated()方法返回false，则Shiro将请求重定向到ShiroFilter配置好的loginUrl进行登录处理。
3.由于TGC不能成功匹配TGT，因此CAS服务端认为用户未进行登录，将请求转发到登录页面。
4.输入用户名/密码进行登录，若CAS服务端认证成功，则生成TGC Cookie保存到客户端浏览器进程所占用的内存，生成TGT保存在CAS服务端位于的内存，通过TGT签发ST，最终回调service参数中的URL并携带ticket参数传递ST，若CAS服务端认证失败，则提示密码错误。
5.若CAS认证成功则请求最终到达项目A的CasFilter，执行其executeLogin方法(即执行分子系统的Shiro认证)
5.1 从HTTP请求中获取ticket参数，将其构造成CasToken实例。
5.2 执行Subject.login(AuthenticationToken token)方法。
5.3 SecurityManager首先判断缓存中是否存在用户对应的AuthenticationInfo实体，若不存在则调用CasRealm的doGetAuthenticationInfo方法进行获取并将其放入到缓存中，执行分子系统的认证操作，最终将authenticated属性设置为true标识用户已进行登录并将用户的身份信息放入Subject的PrincipalCollection实体。
5.4 若用户访问的资源需要权限，此时Shiro就会调用Subject的isPermitted(String str)方法来检验用户的权限，首先判断Subject中的PincipalCollection实体是否包用户的身份信息 (已登录才有)，若包含则判断缓存中是否存在用户对应的AuthorizationInfo实体，若存在则从缓存中获取，否则将调用Realm的doGetAuthorizationInfo方法进行获取，最终将AuthorizationInfo实体放入缓存。
5.5 若用户具有特定的权限则允许访问资源，否则将跳转到ShiroFilter配置好的unauthorizedUrl。
*Shiro是通过Subject的isAuthenticated()方法判断当前用户是否已经登录的，当执行登录操作后会将Subject的authenticated属性设值为true并将用户的身份信息放入Subject的PrincipalCollection实体中。
*若用户访问的URL是user拦截器的，则Subject根据isAuthenticated()方法和isRememberMe()方法判断用户是否需要进行登录，若任意一个方法返回true则表示用户不需进行登录。
*当关闭浏览器重新访问时将产生新的Subject对象，isAuthenticated()方法返回false，除非设置了RememberMe否则都需要重新进行登录。
*loginUrl的值为CAS服务端的登录处理URL，并且需在URL后拼接Service参数传递当认证成功后的回调地址，回调地址必须进入预定义好的CasFilter过滤器且能支持匿名访问。
*若是通过访问URL被重定向到loginUrl的请求，当认证成功后将会跳转原访问的URL。
*若是直接访问loginUrl请求，当认证成功后会跳转casFilter配置好的successUrl。
	    *
	    *
	    *
	    * */
		//CasToken是AuthenticationToken的实现类,其principal为null,credential为ticket.

		CasToken casToken = (CasToken) token;
		if (token == null) {
			return null;
		}
		String ticket = (String)casToken.getCredentials();
		if (!StringUtils.hasText(ticket)) {
			return null;
		}
		//ticket检验器
		TicketValidator ticketValidator = ensureTicketValidator();
		try {
			// 去CAS服务端中验证ticket的合法性并获取用户名进行补全
			Assertion casAssertion = ticketValidator.validate(ticket, getCasService());
			// 从CAS服务端中获取相关属性,包括用户名、是否设置RememberMe等
			AttributePrincipal casPrincipal = casAssertion.getPrincipal();
			//获取用户名
			String userNmae = casPrincipal.getName();
			Map<String, Object> attributes = casPrincipal.getAttributes();
			casToken.setUserId(userNmae);
			//是否记住我
			String rememberMeAttributeName = getRememberMeAttributeName();
			String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
			boolean isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
			if (isRemembered) {
				casToken.setRememberMe(true);
			}
			//获取用户信息
		    User user = userService.findByUsername(userNmae,Constants.PLATFORM_POLICE+"");
            //权限列表
            List list = null;
            //判断是否有权限
            if(Constants.ADMIN_YES.equals(user.getIsAdmin())) {
                //超管获取全部菜单权限
                list = permissionService.findAllForPlatform(user.getPlatform());
            }else{
                //非超管根据用户ID获取权限
                list = permissionService.findByGAUserId(user.getId());
            }
            user.setPermissionList(list);
			PrincipalCollection principalCollection = new SimplePrincipalCollection(user, getName());
			return new SimpleAuthenticationInfo(principalCollection, ticket);
		} catch (TicketValidationException e) {
			
			throw new CasAuthenticationException("Unable to validate ticket [" + ticket + "]", e);
		}
	}

	@Override
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principal) {
		//存放模块用户拥有的模块列表，key和value都是模块的code
		Map moduleMap= new HashMap<String,String>();
		SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
		User user =  (User) principal.getPrimaryPrincipal();
		//权限列表
		List<ModuleMenu> list = user.getPermissionList();
		if(list!=null && list.size()>0) {
            for (ModuleMenu p : list) {
                simpleAuthorizationInfo.addStringPermission(p.getPermission());
            }
        }
		return simpleAuthorizationInfo;
	}
	//清除缓存
    public void clearCached() {  
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();  
        super.clearCache(principals);  
    }
}
